/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;

@Route(value="redirect")
public class RedirectView
extends Composite<VerticalLayout>
implements BeforeEnterObserver {
    public static final String ROUTE_PATH = "redirect";
    private static final String DATA_TARGET = "RedirectTarget";

    public void beforeEnter(BeforeEnterEvent event) {
        String targetUrl = (String)ComponentUtil.getData((Component)event.getUI(), (String)DATA_TARGET);
        ((VerticalLayout)this.getContent()).removeAll();
        Div div = new Div();
        ((VerticalLayout)this.getContent()).add(new Component[]{div});
        if (targetUrl != null) {
            ComponentUtil.setData((Component)event.getUI(), (String)DATA_TARGET, null);
            div.add("Redirecting to ");
            div.add(new Component[]{new Anchor(targetUrl, targetUrl)});
            event.getUI().getPage().setLocation(targetUrl);
        } else {
            div.add("Redirect view entered without target.");
        }
    }

    public static void redirectToUrl(BeforeEnterEvent event, String targetUrl) {
        ComponentUtil.setData((Component)event.getUI(), (String)DATA_TARGET, (Object)targetUrl);
        if (!RouteConfiguration.forSessionScope().isPathAvailable(ROUTE_PATH)) {
            RouteConfiguration.forSessionScope().setRoute(ROUTE_PATH, RedirectView.class);
        }
        event.rerouteTo(RedirectView.class);
    }
}

