/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin;

import de.codecentric.boot.admin.server.config.AdminServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Profile(value={"insecure"})
@Configuration(proxyBeanMethods=false)
public class SecurityPermitAllConfig
extends WebSecurityConfigurerAdapter {
    private final AdminServerProperties adminServer;

    public SecurityPermitAllConfig(AdminServerProperties adminServer) {
        this.adminServer = adminServer;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.authorizeRequests(authorizeRequest -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequest.anyRequest()).permitAll()).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(this.adminServer.path("/instances"), HttpMethod.POST.toString()), new AntPathRequestMatcher(this.adminServer.path("/instances/*"), HttpMethod.DELETE.toString()), new AntPathRequestMatcher(this.adminServer.path("/actuator/**"))}));
    }
}

