/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin;

import de.codecentric.boot.admin.CustomEndpoint;
import de.codecentric.boot.admin.CustomNotifier;
import de.codecentric.boot.admin.NotifierConfig;
import de.codecentric.boot.admin.SecurityPermitAllConfig;
import de.codecentric.boot.admin.SecuritySecureConfig;
import de.codecentric.boot.admin.server.config.EnableAdminServer;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.InMemoryAuditEventRepository;
import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.actuate.trace.http.InMemoryHttpTraceRepository;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration
@EnableAdminServer
@Import(value={SecurityPermitAllConfig.class, SecuritySecureConfig.class, NotifierConfig.class})
@Lazy(value=false)
public class SpringBootAdminServletApplication {
    private static final Logger log = LoggerFactory.getLogger(SpringBootAdminServletApplication.class);

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{SpringBootAdminServletApplication.class});
        app.setApplicationStartup((ApplicationStartup)new BufferingApplicationStartup(1500));
        app.run(args);
    }

    @Bean
    public InstanceExchangeFilterFunction auditLog() {
        return (instance, request, next) -> next.exchange(request).doOnSubscribe(s -> {
            if (HttpMethod.DELETE.equals((Object)request.method()) || HttpMethod.POST.equals((Object)request.method())) {
                log.info("{} for {} on {}", new Object[]{request.method(), instance.getId(), request.url()});
            }
        });
    }

    @Bean
    public CustomNotifier customNotifier(InstanceRepository repository) {
        return new CustomNotifier(repository);
    }

    @Bean
    public CustomEndpoint customEndpoint() {
        return new CustomEndpoint();
    }

    @Bean
    public HttpHeadersProvider customHttpHeadersProvider() {
        return instance -> {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("X-CUSTOM", "My Custom Value");
            return httpHeaders;
        };
    }

    @Bean
    public HttpTraceRepository httpTraceRepository() {
        return new InMemoryHttpTraceRepository();
    }

    @Bean
    public AuditEventRepository auditEventRepository() {
        return new InMemoryAuditEventRepository();
    }

    @Bean
    public EmbeddedDatabase dataSource() {
        return new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseType.HSQL).addScript("org/springframework/session/jdbc/schema-hsqldb.sql").build();
    }
}

