/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.backend.impl.repository;

import de.digitalcollections.iiif.bookshelf.backend.api.repository.IiifManifestSummaryRepository;
import de.digitalcollections.iiif.bookshelf.backend.api.repository.IiifManifestSummarySearchRepository;
import de.digitalcollections.iiif.bookshelf.model.IiifManifestSummary;
import de.digitalcollections.iiif.bookshelf.model.exceptions.SearchSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class IiifManifestSummarySearchRepositoryImplSolrj
implements IiifManifestSummarySearchRepository<UUID> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IiifManifestSummarySearchRepositoryImplSolrj.class);
    @Autowired
    private IiifManifestSummaryRepository iiifManifestSummaryRepository;
    @Autowired
    private SolrClient solr;
    @Value(value="${custom.solr.collection}")
    private String collection;

    public void deleteById(String id) {
        try {
            this.solr.deleteById(this.collection, id);
            this.solr.commit(this.collection);
        }
        catch (IOException | SolrServerException exception) {
            LOGGER.error("Could not delete " + id, exception);
        }
    }

    @Override
    public List<UUID> findBy(String text) {
        QueryResponse response;
        SolrQuery query = this.buildSolrQuery(text, 0);
        try {
            response = this.solr.query(this.collection, (SolrParams)query);
        }
        catch (IOException | SolrServerException ex) {
            LOGGER.error(null, ex);
            return new ArrayList<UUID>();
        }
        SolrDocumentList rs = response.getResults();
        long numFound = rs.getNumFound();
        int current = 0;
        while ((long)current < numFound) {
            query.setStart(Integer.valueOf(current += rs.size()));
            try {
                response = this.solr.query(this.collection, (SolrParams)query);
            }
            catch (IOException | SolrServerException ex) {
                LOGGER.error(null, ex);
            }
            rs = response.getResults();
            numFound = rs.getNumFound();
        }
        LOGGER.info("--------------------------------------------------Results: " + rs.size());
        return this.getUUIDs((List<SolrDocument>)rs);
    }

    @Override
    public Page<IiifManifestSummary> findBy(String text, Pageable pageable) throws SearchSyntaxException {
        QueryResponse response;
        SolrQuery query = this.buildSolrQuery(text, pageable.getOffset());
        query.setRows(Integer.valueOf(pageable.getPageSize()));
        try {
            LOGGER.info("Query = " + query);
            response = this.solr.query(this.collection, (SolrParams)query);
        }
        catch (IOException | SolrServerException ex) {
            LOGGER.error(null, ex);
            return new PageImpl(new ArrayList());
        }
        catch (Exception e) {
            LOGGER.error(null, (Throwable)e);
            if (e.getMessage().contains("SyntaxError")) {
                throw new SearchSyntaxException();
            }
            throw e;
        }
        SolrDocumentList result = response.getResults();
        List<UUID> uuids = this.getUUIDs((List<SolrDocument>)result);
        List<IiifManifestSummary> manifests = this.iiifManifestSummaryRepository.findByUuidIn(uuids);
        LOGGER.info("Found " + uuids.size() + " UUIDs and " + manifests.size() + " manifests.");
        return new PageImpl(manifests, pageable, result.getNumFound());
    }

    @Override
    public List<UUID> findBy(String text, int start, int rows) {
        QueryResponse response;
        SolrQuery query = this.buildSolrQuery(text, start);
        query.setRows(Integer.valueOf(rows));
        try {
            response = this.solr.query(this.collection, (SolrParams)query);
        }
        catch (IOException | SolrServerException ex) {
            LOGGER.error(null, ex);
            return new ArrayList<UUID>();
        }
        SolrDocumentList results = response.getResults();
        LOGGER.info("--------------------------------------------------Results: " + results.size());
        return this.getUUIDs((List<SolrDocument>)results);
    }

    @Override
    public void save(IiifManifestSummary manifestSummary) {
        String value;
        String key;
        try {
            this.solr.deleteByQuery(this.collection, "id:" + manifestSummary.getUuid().toString());
            this.solr.commit(this.collection);
        }
        catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException exception) {
            LOGGER.error("Could not delete existing " + manifestSummary, exception);
        }
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("id", (Object)manifestSummary.getUuid().toString());
        doc.addField("manifesturi_keu", (Object)manifestSummary.getManifestUri());
        String[] uri = manifestSummary.getManifestUri().split("/");
        doc.addField("identifier_str", (Object)uri[uri.length - 2]);
        for (Map.Entry<Locale, String> e : manifestSummary.getLabels().entrySet()) {
            key = e.getKey().getLanguage();
            value = e.getValue();
            doc.addField("label" + key.toUpperCase() + "_txt", (Object)value);
        }
        for (Map.Entry<Locale, String> e : manifestSummary.getDescriptions().entrySet()) {
            key = e.getKey().getLanguage();
            value = e.getValue();
            doc.addField("description" + key.toUpperCase() + "_txt", (Object)value);
        }
        try {
            this.solr.add(this.collection, doc);
            this.solr.commit(this.collection);
        }
        catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException ex) {
            LOGGER.error("Could not save ", ex);
        }
    }

    private List<UUID> getUUIDs(List<SolrDocument> docs) {
        ArrayList<UUID> ids = new ArrayList<UUID>(docs.size());
        for (SolrDocument doc : docs) {
            UUID uuid = this.createUUID(doc.getFirstValue("id"));
            ids.add(uuid);
            LOGGER.info("Solr id: " + uuid);
        }
        return ids;
    }

    private UUID createUUID(Object value) {
        return UUID.fromString(value.toString());
    }

    protected String escapeUnwantedSpecialChars(String text) {
        return ClientUtils.escapeQueryChars((String)text).replaceAll("\\\\\\*", "*").replaceAll("\\\\\\?", "?").replaceAll("\\\\\\s", " ").replaceAll("\\\\\\\"", "\"");
    }

    private SolrQuery buildSolrQuery(String text, int start) {
        SolrQuery query = new SolrQuery();
        String trimmedQuery = this.escapeUnwantedSpecialChars(text);
        query.set("defType", new String[]{"edismax"});
        query.set("q.op", new String[]{"AND"});
        query.set("qf", new String[]{"text identifier_str manifesturi_keu"});
        query.setQuery(trimmedQuery);
        query.setFields(new String[]{"id"});
        query.setStart(Integer.valueOf(start));
        return query;
    }
}

