/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.business.impl.service;

import de.digitalcollections.iiif.bookshelf.business.impl.service.AbstractManifestParser;
import de.digitalcollections.iiif.bookshelf.model.IiifManifestSummary;
import de.digitalcollections.iiif.bookshelf.model.Thumbnail;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.Size;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GraciousManifestParser
extends AbstractManifestParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraciousManifestParser.class);
    public static final Locale DEFAULT_LOCALE = Locale.GERMAN;

    @Override
    public void fillSummary(IiifManifestSummary manifestSummary) throws IOException, URISyntaxException {
        InputStream is;
        try {
            is = this.getContentInputStream(manifestSummary.getManifestUri());
        }
        catch (UnsupportedOperationException ex) {
            throw new IOException(ex);
        }
        this.fillFromInputStream(is, manifestSummary);
    }

    protected void fillFromInputStream(InputStream is, IiifManifestSummary manifestSummary) throws IOException {
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            this.fillFromJsonObject(jsonObject, manifestSummary);
        }
        catch (ParseException ex) {
            LOGGER.warn("Could not parse json at {}.", (Object)manifestSummary.getManifestUri());
            throw new IOException("Invalid JSON.");
        }
    }

    private void fillFromJsonObject(JSONObject jsonObject, IiifManifestSummary manifestSummary) throws ParseException {
        Object label = jsonObject.get((Object)"label");
        HashMap<Locale, String> localizedLabels = this.getLocalizedStrings(label);
        manifestSummary.setLabels(localizedLabels);
        Object description = jsonObject.get((Object)"description");
        HashMap<Locale, String> localizedDescriptions = this.getLocalizedStrings(description);
        manifestSummary.setDescriptions(localizedDescriptions);
        Object attribution = jsonObject.get((Object)"attribution");
        HashMap<Locale, String> localizedAttributions = this.getLocalizedStrings(attribution);
        manifestSummary.setAttributions(localizedAttributions);
        Thumbnail thumbnail = this.getThumbnail(jsonObject);
        manifestSummary.setThumbnail(thumbnail);
        String logoUrl = null;
        Object logo = jsonObject.get((Object)"logo");
        if (logo instanceof JSONObject) {
            logoUrl = (String)((JSONObject)logo).get((Object)"@id");
        }
        if (logo instanceof String) {
            logoUrl = (String)logo;
        }
        if (!StringUtils.isEmpty(logoUrl)) {
            manifestSummary.setLogoUrl(logoUrl);
        }
    }

    public HashMap<Locale, String> getLocalizedStrings(Object jsonNode) {
        HashMap<Locale, String> result = new HashMap<Locale, String>();
        if (jsonNode == null) {
            return result;
        }
        if (JSONArray.class.isAssignableFrom(jsonNode.getClass())) {
            JSONArray descriptions = (JSONArray)jsonNode;
            for (Object descr : descriptions) {
                JSONObject descrObj = (JSONObject)descr;
                String value = (String)descrObj.get((Object)"@value");
                String language = (String)descrObj.get((Object)"@language");
                result.put(new Locale(language), value);
            }
        } else {
            String value = (String)jsonNode;
            result.put(DEFAULT_LOCALE, value);
        }
        return result;
    }

    private Thumbnail getThumbnail(JSONObject manifestObj) {
        Object obj;
        JSONArray images;
        JSONObject firstCanvas;
        Object obj2;
        JSONArray sequencesArray;
        JSONObject thumbnailObj = (JSONObject)manifestObj.get((Object)"thumbnail");
        JSONObject firstSequence = null;
        if (thumbnailObj == null && (sequencesArray = (JSONArray)manifestObj.get((Object)"sequences")) != null && (firstSequence = (JSONObject)sequencesArray.get(0)) != null) {
            thumbnailObj = (JSONObject)firstSequence.get((Object)"thumbnail");
        }
        JSONArray canvases = null;
        if (thumbnailObj == null && firstSequence != null && (canvases = (JSONArray)firstSequence.get((Object)"canvases")) != null && (obj2 = canvases.stream().map(c -> ((JSONObject)c).get((Object)"thumbnail")).filter(t -> t != null).findFirst().orElse(null)) != null && obj2 instanceof JSONObject) {
            thumbnailObj = obj2;
        }
        if (thumbnailObj == null && canvases != null && (firstCanvas = (JSONObject)canvases.get(0)) != null && (images = (JSONArray)firstCanvas.get((Object)"images")) != null && (obj = images.stream().map(i -> ((JSONObject)i).get((Object)"resource")).findFirst().orElse(null)) != null && obj instanceof JSONObject) {
            thumbnailObj = obj;
        }
        if (thumbnailObj != null) {
            JSONObject serviceObj = (JSONObject)thumbnailObj.get((Object)"service");
            if (serviceObj != null) {
                String serviceUrl;
                boolean isV1 = false;
                String profile = null;
                Object profileObj = serviceObj.get((Object)"profile");
                if (profileObj == null) {
                    profileObj = (String)serviceObj.get((Object)"dcterms:conformsTo");
                }
                if (profileObj instanceof JSONArray) {
                    profile = (String)((JSONArray)profileObj).get(0);
                }
                if (profileObj instanceof String) {
                    profile = (String)profileObj;
                }
                if (profile != null) {
                    isV1 = ImageApiProfile.V1_PROFILES.contains(profile);
                }
                if ((serviceUrl = (String)serviceObj.get((Object)"@id")).endsWith("/")) {
                    serviceUrl = serviceUrl.substring(0, serviceUrl.length() - 1);
                }
                ArrayList<Size> sizes = new ArrayList<Size>();
                JSONArray sizesArray = (JSONArray)serviceObj.get((Object)"sizes");
                if (sizesArray != null) {
                    for (Object size : sizesArray) {
                        JSONObject sizeObj = (JSONObject)size;
                        int width = new Long((Long)sizeObj.get((Object)"width")).intValue();
                        int height = new Long((Long)sizeObj.get((Object)"height")).intValue();
                        sizes.add(new Size(width, height));
                    }
                }
                return this.createThumbnail(sizes, serviceUrl, isV1);
            }
            return new Thumbnail(thumbnailObj.get((Object)"@id").toString());
        }
        return null;
    }
}

