/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.business.impl.service;

import de.digitalcollections.iiif.bookshelf.business.api.service.IiifCollectionService;
import de.digitalcollections.iiif.bookshelf.business.api.service.IiifManifestSummaryService;
import de.digitalcollections.iiif.bookshelf.business.impl.service.StrictCollectionParser;
import de.digitalcollections.iiif.bookshelf.model.IiifManifestSummary;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IiifCollectionServiceImpl
implements IiifCollectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IiifCollectionServiceImpl.class);
    @Autowired
    private IiifManifestSummaryService iiifManifestSummaryService;
    @Autowired
    private StrictCollectionParser strictCollectionParser;

    @Override
    public void importAllObjects(IiifManifestSummary manifestSummary) throws URISyntaxException, IOException {
        Collection collection = this.strictCollectionParser.parse(manifestSummary.getManifestUri());
        this.saveManifestsFromCollection(collection);
    }

    private void saveManifestsFromCollection(Collection collection) throws IOException {
        List manifests = collection.getManifests();
        List subCollections = collection.getCollections();
        int manifestsCount = manifests != null ? manifests.size() : -1;
        int subCollectionsCount = subCollections != null ? subCollections.size() : -1;
        LOGGER.info("processing collection '{}' with {} manifests and {} sub collections.", new Object[]{collection.getIdentifier().toString(), manifestsCount, subCollectionsCount});
        if (manifests != null) {
            for (Manifest manifest : manifests) {
                String manifestUri = manifest.getIdentifier().toString();
                IiifManifestSummary summary = new IiifManifestSummary();
                summary.setManifestUri(manifestUri);
                try {
                    this.iiifManifestSummaryService.enrichAndSave(summary);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not read manifest from {} because of error {}", (Object)manifestUri, (Object)e.getMessage());
                }
            }
        }
        if (subCollections != null) {
            for (Collection subCollection : subCollections) {
                String subCollectionIdentifier = subCollection.getIdentifier().toString();
                try {
                    subCollection = this.strictCollectionParser.parse(subCollectionIdentifier);
                    this.saveManifestsFromCollection(subCollection);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not read collection from {} because of error {}", (Object)subCollectionIdentifier, (Object)e.getMessage());
                }
            }
        }
    }
}

