/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.business.impl.service;

import de.digitalcollections.iiif.bookshelf.backend.api.repository.IiifManifestSummaryRepository;
import de.digitalcollections.iiif.bookshelf.backend.api.repository.IiifManifestSummarySearchRepository;
import de.digitalcollections.iiif.bookshelf.business.api.service.IiifManifestSummaryService;
import de.digitalcollections.iiif.bookshelf.business.impl.service.GraciousManifestParser;
import de.digitalcollections.iiif.bookshelf.business.impl.service.StrictManifestParser;
import de.digitalcollections.iiif.bookshelf.model.IiifManifestSummary;
import de.digitalcollections.iiif.bookshelf.model.exceptions.NotFoundException;
import de.digitalcollections.iiif.bookshelf.model.exceptions.SearchSyntaxException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class IiifManifestSummaryServiceImpl
implements IiifManifestSummaryService {
    public static final Locale DEFAULT_LOCALE = Locale.GERMAN;
    private static final Logger LOGGER = LoggerFactory.getLogger(IiifManifestSummaryServiceImpl.class);
    @Autowired
    private GraciousManifestParser graciousManifestParser;
    @Value(value="${custom.iiif.graciousParsing}")
    private boolean graciousParsing;
    @Autowired
    private IiifManifestSummaryRepository iiifManifestSummaryRepository;
    @Autowired
    private IiifManifestSummarySearchRepository iiifManifestSummarySearchRepository;
    @Autowired
    private StrictManifestParser strictManifestParser;

    @Override
    public IiifManifestSummary add(IiifManifestSummary manifest) {
        IiifManifestSummary existingManifest = this.iiifManifestSummaryRepository.findByManifestUri(manifest.getManifestUri());
        if (existingManifest != null) {
            throw new IllegalArgumentException("object already exists");
        }
        return (IiifManifestSummary)this.iiifManifestSummaryRepository.save(manifest);
    }

    @Override
    public long countAll() {
        return this.iiifManifestSummaryRepository.count();
    }

    @Override
    public void enrichAndSave(IiifManifestSummary manifestSummary) throws URISyntaxException, NotFoundException, IOException {
        try {
            this.strictManifestParser.fillSummary(manifestSummary);
        }
        catch (Exception ex) {
            if (this.graciousParsing) {
                LOGGER.warn("Manifest at uri {} might be not standard conform, trying gracious parsing.", (Object)manifestSummary.getManifestUri(), (Object)ex);
                this.graciousManifestParser.fillSummary(manifestSummary);
            }
            throw ex;
        }
        String viewId = this.getViewId(manifestSummary);
        manifestSummary.setViewId(viewId);
        IiifManifestSummary existingManifest = this.prepareUpdateIfAlreadyExists(manifestSummary.getManifestUri(), manifestSummary);
        try {
            this.iiifManifestSummaryRepository.save(manifestSummary);
        }
        catch (Exception ex) {
            LOGGER.error("Error saving manifest with uri '{}', existing manifest uri '{}'", (Object)manifestSummary.getManifestUri(), (Object)(existingManifest != null ? existingManifest.getManifestUri() : "not existing"));
            throw ex;
        }
        this.iiifManifestSummarySearchRepository.save(manifestSummary);
        LOGGER.info("Successfully imported and indexed {}", (Object)manifestSummary.getManifestUri());
    }

    @Override
    public Page<IiifManifestSummary> findAll(String searchText, Pageable pageable) throws SearchSyntaxException {
        return this.iiifManifestSummarySearchRepository.findBy(searchText, pageable);
    }

    @Override
    public IiifManifestSummary get(String id) {
        UUID uuid;
        try {
            uuid = UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            uuid = null;
        }
        List<IiifManifestSummary> objects = this.iiifManifestSummaryRepository.findByViewIdOrUuid(id, uuid);
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        if (objects.size() > 1) {
            return null;
        }
        return objects.get(0);
    }

    @Override
    public IiifManifestSummary get(UUID uuid) {
        return (IiifManifestSummary)this.iiifManifestSummaryRepository.findOne(uuid);
    }

    @Override
    public List<IiifManifestSummary> getAll() {
        return this.iiifManifestSummaryRepository.findAllByOrderByLastModifiedDesc();
    }

    @Override
    public Page<IiifManifestSummary> getAll(Pageable pageable) {
        return this.iiifManifestSummaryRepository.findAllByOrderByLastModifiedDesc(pageable);
    }

    @Override
    public String getLabel(IiifManifestSummary manifestSummary, Locale locale) {
        String result = null;
        if (manifestSummary == null) {
            return result;
        }
        result = manifestSummary.getLabel(locale);
        if (result == null) {
            result = manifestSummary.getLabel(DEFAULT_LOCALE);
        }
        if (result == null) {
            result = (String)manifestSummary.getLabels().values().toArray()[0];
        }
        return result;
    }

    protected String getViewId(IiifManifestSummary manifestSummary) {
        try {
            String viewId = manifestSummary.getManifestUri();
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] sha1 = digest.digest(viewId.getBytes(StandardCharsets.UTF_8));
            viewId = DatatypeConverter.printHexBinary((byte[])sha1);
            return viewId.substring(0, 8);
        }
        catch (NoSuchAlgorithmException ex) {
            return manifestSummary.getUuid().toString();
        }
    }

    private IiifManifestSummary prepareUpdateIfAlreadyExists(String manifestIdentifier, IiifManifestSummary manifestSummary) {
        IiifManifestSummary existingManifest = this.iiifManifestSummaryRepository.findByManifestUri(manifestIdentifier);
        if (existingManifest != null) {
            manifestSummary.setUuid(existingManifest.getUuid());
            manifestSummary.setViewId(existingManifest.getViewId());
        }
        return existingManifest;
    }

    @Override
    public void reindexSearch() {
        for (IiifManifestSummary summary : this.iiifManifestSummaryRepository.findAll()) {
            this.iiifManifestSummarySearchRepository.save(summary);
        }
    }
}

