/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.business.impl.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.iiif.bookshelf.business.impl.service.AbstractManifestParser;
import de.digitalcollections.iiif.bookshelf.model.IiifManifestSummary;
import de.digitalcollections.iiif.bookshelf.model.Thumbnail;
import de.digitalcollections.iiif.bookshelf.model.exceptions.NotFoundException;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageService;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.iiif.model.openannotation.Choice;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StrictManifestParser
extends AbstractManifestParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrictManifestParser.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public void fillSummary(IiifManifestSummary manifestSummary) throws IOException, URISyntaxException {
        InputStream is;
        try {
            is = this.getContentInputStream(manifestSummary.getManifestUri());
        }
        catch (UnsupportedOperationException ex) {
            throw new IOException(ex);
        }
        Manifest manifest = (Manifest)this.objectMapper.readValue(is, Manifest.class);
        this.fillFromManifest(manifest, manifestSummary);
    }

    private void fillFromManifest(Manifest manifest, IiifManifestSummary manifestSummary) throws NotFoundException {
        manifestSummary.setManifestUri(manifest.getIdentifier().toString());
        manifestSummary.setLabels(this.getLocalizedStrings(manifest.getLabel()));
        manifestSummary.setDescriptions(this.getLocalizedStrings(manifest.getDescription()));
        manifestSummary.setAttributions(this.getLocalizedStrings(manifest.getAttribution()));
        Thumbnail thumbnail = this.getThumbnail(manifest);
        manifestSummary.setThumbnail(thumbnail);
        URI logoUri = manifest.getLogoUri();
        if (logoUri != null) {
            manifestSummary.setLogoUrl(logoUri.toString());
        }
    }

    public HashMap<Locale, String> getLocalizedStrings(PropertyValue val) {
        HashMap<Locale, String> strings = new HashMap<Locale, String>();
        if (val != null) {
            val.getLocalizations().forEach(l -> strings.put((Locale)l, val.getFirstValue(l)));
        }
        return strings;
    }

    public void setObjectMapper(IiifObjectMapper mapper) {
        this.objectMapper = mapper;
    }

    public Thumbnail getThumbnail(Manifest manifest) {
        ImageContent imageContent = null;
        if (manifest.getThumbnails() != null) {
            imageContent = manifest.getThumbnail();
        }
        if (imageContent == null && manifest.getDefaultSequence() != null) {
            imageContent = manifest.getDefaultSequence().getThumbnail();
        }
        if (imageContent == null && manifest.getDefaultSequence() != null && manifest.getDefaultSequence().getCanvases() != null) {
            imageContent = manifest.getDefaultSequence().getCanvases().stream().map(c -> c.getThumbnails()).filter(ts -> ts != null && ts.size() > 0).map(ts -> (ImageContent)ts.get(0)).findFirst().orElse(null);
        }
        if (imageContent == null) {
            imageContent = ((Canvas)manifest.getDefaultSequence().getCanvases().get(0)).getImages().stream().map(a -> {
                if (a.getResource() instanceof ImageContent) {
                    return (ImageContent)a.getResource();
                }
                return (ImageContent)((Choice)a.getResource()).getDefault();
            }).findFirst().orElse(null);
        }
        if (imageContent != null) {
            ImageService imageService = null;
            if (imageContent.getServices() != null) {
                imageService = imageContent.getServices().stream().filter(ImageService.class::isInstance).map(ImageService.class::cast).findFirst().orElse(null);
            }
            if (imageService != null) {
                boolean isV1 = imageService.getProfiles().stream().map(p -> p.getIdentifier().toString()).anyMatch(ImageApiProfile.V1_PROFILES::contains);
                String serviceUrl = imageService.getIdentifier().toString();
                if (serviceUrl.endsWith("/")) {
                    serviceUrl = serviceUrl.substring(0, serviceUrl.length() - 1);
                }
                List sizes = imageService.getSizes();
                return this.createThumbnail(sizes, serviceUrl, isV1);
            }
            return new Thumbnail(imageContent.getIdentifier().toString());
        }
        return null;
    }
}

