/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.config;

import de.digitalcollections.iiif.bookshelf.config.SpringConfigBackend;
import de.digitalcollections.iiif.bookshelf.config.SpringConfigBusiness;
import de.digitalcollections.iiif.bookshelf.config.SpringConfigSecurity;
import de.digitalcollections.iiif.bookshelf.config.SpringConfigWeb;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={SpringConfigSecurity.class, SpringConfigWeb.class, SpringConfigBusiness.class, SpringConfigBackend.class})
public class SpringConfig
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfig.class);

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean(name={"messageSource"})
    public MessageSource configureMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"classpath:messages", "classpath:messages-overlay", "classpath:messages-commons"});
        messageSource.setCacheSeconds(5);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    public void setEnvironment(Environment environment) {
        Object[] activeProfiles = environment.getActiveProfiles();
        String toString = Arrays.toString(activeProfiles);
        LOGGER.info("##### Active Profiles: " + toString);
    }
}

