/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;

@Configuration
@EnableWebSecurity
public class SpringConfigSecurity
extends WebSecurityConfigurerAdapter {
    @Value(value="${custom.app.security.enabled}")
    private boolean authentication;
    @Value(value="${custom.app.security.username}")
    private String username;
    @Value(value="${custom.app.security.password}")
    private String password;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        if (this.authentication) {
            auth.inMemoryAuthentication().withUser(this.username).password(this.password).roles(new String[]{"USER"});
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll().and()).formLogin().loginPage("/login").and()).httpBasic().and()).headers().frameOptions().disable();
    }

    @Configuration
    @Order(value=2)
    public static class FormLoginWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${custom.app.security.enabled}")
        private boolean authentication;

        protected void configure(HttpSecurity http) throws Exception {
            if (!this.authentication) {
                return;
            }
            ((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/add").authorizeRequests().antMatchers(new String[]{"/add"})).authenticated().and()).formLogin().loginPage("/login").permitAll()).and()).httpBasic();
        }
    }

    @Configuration
    @Order(value=1)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${custom.app.security.enabled}")
        private boolean authentication;

        protected void configure(HttpSecurity http) throws Exception {
            if (!this.authentication) {
                return;
            }
            ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/add").authorizeRequests().antMatchers(new String[]{"/api/add"})).authenticated().and()).httpBasic().and()).csrf().disable();
        }
    }
}

