/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.frontend.controller;

import com.google.common.collect.Maps;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.iiif.bookshelf.business.api.service.IiifCollectionService;
import de.digitalcollections.iiif.bookshelf.business.api.service.IiifManifestSummaryService;
import de.digitalcollections.iiif.bookshelf.frontend.controller.ApiException;
import de.digitalcollections.iiif.bookshelf.frontend.model.PageWrapper;
import de.digitalcollections.iiif.bookshelf.model.IiifManifestSummary;
import de.digitalcollections.iiif.bookshelf.model.SearchRequest;
import de.digitalcollections.iiif.bookshelf.model.exceptions.NotFoundException;
import de.digitalcollections.iiif.bookshelf.model.exceptions.SearchSyntaxException;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebController.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Value(value="#{iiifVersions}")
    private Map<String, Object> iiifVersions;
    @Value(value="${custom.app.security.enabled}")
    private boolean authentication;
    @Autowired
    private IiifCollectionService iiifCollectionService;
    @Autowired
    private IiifManifestSummaryService iiifManifestSummaryService;
    @Autowired
    private IiifObjectMapper iiifObjectMapper;

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    public String list(SearchRequest searchRequest, Model model, Pageable pageRequest, @RequestParam(required=false, defaultValue="grid") String style, BindingResult results) {
        this.verifyBinding(results);
        model.addAttribute("authentication", (Object)this.authentication);
        Page<IiifManifestSummary> page = this.iiifManifestSummaryService.getAll(pageRequest);
        model.addAttribute("menu", (Object)"home");
        model.addAttribute("page", new PageWrapper<IiifManifestSummary>(page, "/"));
        model.addAttribute("searchRequest", (Object)new SearchRequest());
        model.addAttribute("style", (Object)style);
        return "index";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(Model model) {
        model.addAttribute("manifest", (Object)new IiifManifestSummary());
        return "add";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String add(IiifManifestSummary manifestSummary, Model model) {
        try {
            this.iiifManifestSummaryService.enrichAndSave(manifestSummary);
        }
        catch (IOException e) {
            LOGGER.warn("Could not load manifest from {} because of malformed JSON", (Object)manifestSummary.getManifestUri(), (Object)e);
            model.addAttribute("manifest", (Object)manifestSummary);
            model.addAttribute("errorMessage", (Object)"Manifest at URL contains malformed JSON.");
            return "add";
        }
        catch (NotFoundException e) {
            LOGGER.warn("Could not find manifest at {}", (Object)manifestSummary.getManifestUri(), (Object)e);
            model.addAttribute("manifest", (Object)manifestSummary);
            model.addAttribute("errorMessage", (Object)"No Manifest was found at URL.");
            return "add";
        }
        catch (Exception e) {
            LOGGER.warn("Could not add manifest from {}", (Object)manifestSummary.getManifestUri(), (Object)e);
        }
        return "redirect:/";
    }

    @RequestMapping(value={"/addCollection"}, method={RequestMethod.POST})
    public String addCollection(IiifManifestSummary manifestSummary, Model model) {
        try {
            this.iiifCollectionService.importAllObjects(manifestSummary);
        }
        catch (Exception e) {
            LOGGER.warn("Could not add collection manifest from {}", (Object)manifestSummary.getManifestUri(), (Object)e);
            model.addAttribute("manifest", (Object)manifestSummary);
            model.addAttribute("errorMessage", (Object)("Could not add collection manifest from " + manifestSummary.getManifestUri()));
            return "add";
        }
        return "redirect:/";
    }

    @ResponseBody
    @RequestMapping(value={"/api/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public IiifManifestSummary apiAdd(@RequestParam(value="uri") String manifestUri) throws ApiException {
        IiifManifestSummary summary = new IiifManifestSummary();
        summary.setManifestUri(manifestUri);
        try {
            this.iiifManifestSummaryService.enrichAndSave(summary);
            return summary;
        }
        catch (IOException e) {
            LOGGER.warn("IOException for manifest at {}: ", (Object)manifestUri, (Object)e);
            throw new ApiException("Invalid manifest at URL '" + manifestUri + "'", HttpStatus.BAD_REQUEST);
        }
        catch (NotFoundException | URISyntaxException e) {
            LOGGER.warn("Exception for manifest at {}: ", (Object)manifestUri, (Object)e);
            throw new ApiException("No manifest at URL '" + manifestUri + "'", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.warn("Exception for manifest at {}: ", (Object)manifestUri, (Object)e);
            throw new ApiException("Exception for manifest at: '" + manifestUri + "'", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/api/addCollection"}, method={RequestMethod.POST}, produces={"application/json"})
    public boolean apiAddCollection(@RequestParam(value="uri") String manifestUri) throws ApiException {
        IiifManifestSummary summary = new IiifManifestSummary();
        summary.setManifestUri(manifestUri);
        try {
            this.iiifCollectionService.importAllObjects(summary);
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("IOException for collection at {}: ", (Object)manifestUri, (Object)e);
            throw new ApiException("Invalid collection manifest at URL '" + manifestUri + "'", HttpStatus.BAD_REQUEST);
        }
        catch (URISyntaxException e) {
            throw new ApiException("No collection manifest at URL '" + manifestUri + "'", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.warn("Exception for collection at {}: ", (Object)manifestUri, (Object)e);
            throw new ApiException("Exception for collection at: '" + manifestUri + "'", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    @Deprecated
    public String oldViewObject(@PathVariable String id, Model model) {
        return "redirect:/" + id + "/view";
    }

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/{id}/view"}, method={RequestMethod.GET})
    public String viewObject(@PathVariable String id, Model model) {
        IiifManifestSummary iiifManifestSummary;
        try {
            String viewId;
            UUID uuid = UUID.fromString(id);
            iiifManifestSummary = this.iiifManifestSummaryService.get(uuid);
            if (iiifManifestSummary != null && (viewId = iiifManifestSummary.getViewId()) != null && !uuid.toString().equals(viewId)) {
                return "redirect:/" + iiifManifestSummary.getViewId() + "/view";
            }
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        iiifManifestSummary = this.iiifManifestSummaryService.get(id);
        if (iiifManifestSummary == null) {
            throw new NotFoundException();
        }
        model.addAttribute("iiifVersions", this.iiifVersions);
        model.addAttribute("manifestId", (Object)iiifManifestSummary.getManifestUri());
        String title = this.iiifManifestSummaryService.getLabel(iiifManifestSummary, LocaleContextHolder.getLocale());
        model.addAttribute("title", (Object)title);
        model.addAttribute("manifestSummary", (Object)iiifManifestSummary);
        return "mirador/view";
    }

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/{id}/uv"}, method={RequestMethod.GET})
    public String viewObjectInUniversalViewer(@PathVariable String id, Model model) {
        IiifManifestSummary iiifManifestSummary;
        try {
            String viewId;
            UUID uuid = UUID.fromString(id);
            iiifManifestSummary = this.iiifManifestSummaryService.get(uuid);
            if (iiifManifestSummary != null && (viewId = iiifManifestSummary.getViewId()) != null && !uuid.toString().equals(viewId)) {
                return "redirect:/" + iiifManifestSummary.getViewId() + "/uv";
            }
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        iiifManifestSummary = this.iiifManifestSummaryService.get(id);
        if (iiifManifestSummary == null) {
            throw new NotFoundException();
        }
        model.addAttribute("iiifVersions", this.iiifVersions);
        model.addAttribute("manifestId", (Object)iiifManifestSummary.getManifestUri());
        model.addAttribute("manifestSummary", (Object)iiifManifestSummary);
        String title = this.iiifManifestSummaryService.getLabel(iiifManifestSummary, LocaleContextHolder.getLocale());
        model.addAttribute("title", (Object)title);
        return "uv/view";
    }

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/info/{id}"}, method={RequestMethod.GET})
    @Deprecated
    public String oldObjectInfo(@PathVariable String id, Model model) {
        return "redirect:/" + id;
    }

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.HEAD})
    public void objectExists(@PathVariable String id, HttpServletResponse response) throws IOException {
        IiifManifestSummary iiifManifestSummary;
        try {
            UUID uuid = UUID.fromString(id);
            iiifManifestSummary = this.iiifManifestSummaryService.get(uuid);
        }
        catch (IllegalArgumentException e) {
            iiifManifestSummary = this.iiifManifestSummaryService.get(id);
        }
        if (iiifManifestSummary == null) {
            throw new NotFoundException();
        }
        response.setStatus(HttpStatus.OK.value());
    }

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public String objectInfo(@PathVariable String id, Model model, Locale locale) throws IOException {
        IiifManifestSummary iiifManifestSummary;
        try {
            String viewId;
            UUID uuid = UUID.fromString(id);
            iiifManifestSummary = this.iiifManifestSummaryService.get(uuid);
            if (iiifManifestSummary != null && (viewId = iiifManifestSummary.getViewId()) != null && !uuid.toString().equals(viewId)) {
                return "redirect:/" + iiifManifestSummary.getViewId();
            }
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        iiifManifestSummary = this.iiifManifestSummaryService.get(id);
        if (iiifManifestSummary == null) {
            throw new NotFoundException();
        }
        String manifestUri = iiifManifestSummary.getManifestUri();
        model.addAttribute("manifestId", (Object)manifestUri);
        String title = this.iiifManifestSummaryService.getLabel(iiifManifestSummary, LocaleContextHolder.getLocale());
        model.addAttribute("title", (Object)title);
        model.addAttribute("manifestSummary", (Object)iiifManifestSummary);
        try {
            Manifest manifest = (Manifest)this.iiifObjectMapper.readValue(new URL(manifestUri), Manifest.class);
            model.addAttribute("manifest", (Object)manifest);
        }
        catch (Exception e) {
            model.addAttribute("error_message", (Object)this.messageSource.getMessage("manifest_error", new Object[0], locale));
        }
        return "info";
    }

    @ExceptionHandler(value={ApiException.class})
    public ResponseEntity<Map<String, Object>> handleApiException(ApiException e) {
        HashMap rv = Maps.newHashMap();
        rv.put("error", e.message);
        return ResponseEntity.status((HttpStatus)e.statusCode).body((Object)rv);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(SearchRequest searchRequest, Model model, Pageable pageRequest, @RequestParam(required=false, defaultValue="grid") String style, BindingResult results) {
        this.verifyBinding(results);
        model.addAttribute("authentication", (Object)this.authentication);
        if (searchRequest == null) {
            searchRequest = new SearchRequest();
        }
        PageImpl page = null;
        if (!StringUtils.isEmpty((Object)searchRequest.getQuery())) {
            String term = searchRequest.getQuery().replace(":", "\\:");
            if (!StringUtils.isEmpty((Object)term)) {
                try {
                    page = this.iiifManifestSummaryService.findAll(term, pageRequest);
                }
                catch (SearchSyntaxException ex) {
                    page = new PageImpl(new ArrayList());
                    results.reject("error.search_syntax");
                }
            }
        } else {
            page = this.iiifManifestSummaryService.getAll(pageRequest);
        }
        model.addAttribute("menu", (Object)"search");
        model.addAttribute("page", new PageWrapper<IiifManifestSummary>((Page<IiifManifestSummary>)page, "/search"));
        model.addAttribute("searchRequest", (Object)searchRequest);
        model.addAttribute("style", (Object)style);
        return "search-advanced";
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public String login() {
        return "login";
    }
}

