/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.frontend.model;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;

public class PageWrapper<T> {
    public static final int MAX_PAGE_ITEM_DISPLAY = 5;
    private final Page<T> page;
    private final List<PageItem> items;
    private final int currentNumber;
    private final long totalItems;
    private String url;

    public PageWrapper(Page<T> page, String url) {
        int size;
        int start;
        this.page = page;
        this.totalItems = page.getTotalElements();
        this.url = url;
        this.items = new ArrayList<PageItem>();
        this.currentNumber = page.getNumber() + 1;
        if (page.getTotalPages() <= 5) {
            start = 1;
            size = page.getTotalPages();
        } else if (this.currentNumber <= 3) {
            start = 1;
            size = 5;
        } else if (this.currentNumber >= page.getTotalPages() - 2) {
            start = page.getTotalPages() - 5 + 1;
            size = 5;
        } else {
            start = this.currentNumber - 2;
            size = 5;
        }
        for (int i = 0; i < size; ++i) {
            this.items.add(new PageItem(start + i, start + i == this.currentNumber));
        }
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<PageItem> getItems() {
        return this.items;
    }

    public int getNumber() {
        return this.currentNumber;
    }

    public List<T> getContent() {
        return this.page.getContent();
    }

    public int getSize() {
        return this.page.getSize();
    }

    public int getTotalPages() {
        return this.page.getTotalPages();
    }

    public boolean isFirstPage() {
        return this.page.isFirst();
    }

    public boolean isLastPage() {
        return this.page.isLast();
    }

    public boolean isHasPreviousPage() {
        return this.page.hasPrevious();
    }

    public boolean isHasNextPage() {
        return this.page.hasNext();
    }

    public class PageItem {
        private final int number;
        private final boolean current;

        public PageItem(int number, boolean current) {
            this.number = number;
            this.current = current;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean isCurrent() {
            return this.current;
        }
    }
}

