/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.bookshelf.model;

import de.digitalcollections.iiif.bookshelf.model.Thumbnail;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.index.TextIndexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.TextScore;

@Document(collection="iiif-manifest-summaries")
public class IiifManifestSummary {
    @TextIndexed
    private HashMap<Locale, String> attributions = new HashMap();
    @TextIndexed
    private HashMap<Locale, String> descriptions = new HashMap();
    @TextIndexed(weight=2.0f)
    private HashMap<Locale, String> labels = new HashMap();
    @Temporal(value=TemporalType.TIMESTAMP)
    @LastModifiedDate
    @Indexed(direction=IndexDirection.DESCENDING)
    private Date lastModified;
    private String logoUrl;
    @TextIndexed
    private String manifestUri;
    @TextScore
    private Float score;
    private Thumbnail thumbnail;
    @Id
    private UUID uuid = UUID.randomUUID();
    @Indexed(sparse=true, unique=true)
    private String viewId;

    public void addAttribution(Locale locale, String attribution) {
        this.attributions.put(locale, attribution);
    }

    public void addDescription(Locale locale, String description) {
        this.descriptions.put(locale, description);
    }

    public void addLabel(Locale locale, String label) {
        this.labels.put(locale, label);
    }

    public String getAttribution(String language) {
        return this.attributions.get(new Locale(language));
    }

    public String getAttribution(Locale locale) {
        return this.attributions.get(locale);
    }

    public HashMap<Locale, String> getAttributions() {
        return this.attributions;
    }

    public void setAttributions(HashMap<Locale, String> attributions) {
        this.attributions = attributions;
    }

    public String getDescription(Locale locale) {
        return this.descriptions.get(locale);
    }

    public String getDescription(String language) {
        return this.descriptions.get(new Locale(language));
    }

    public HashMap<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(HashMap<Locale, String> descriptions) {
        this.descriptions = descriptions;
    }

    public String getLabel(String language) {
        return this.labels.get(new Locale(language));
    }

    public String getLabel(Locale locale) {
        return this.labels.get(locale);
    }

    public HashMap<Locale, String> getLabels() {
        return this.labels;
    }

    public void setLabels(HashMap<Locale, String> labels) {
        this.labels = labels;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getManifestUri() {
        return this.manifestUri;
    }

    public void setManifestUri(String manifestUri) {
        this.manifestUri = manifestUri;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }
}

