/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.image.model.api.enums;

public enum ImageFormat {
    GIF(new String[]{"gif"}, "image/gif"),
    JP2(new String[]{"jp2", "jpeg2000"}, "image/jp2"),
    JPEG(new String[]{"jpg", "jpeg"}, "image/jpeg"),
    PDF(new String[]{"pdf"}, "application/pdf"),
    PNG(new String[]{"png"}, "image/png"),
    TIF(new String[]{"tif", "tiff"}, "image/tif"),
    WEBP(new String[]{"webp"}, "image/webp");

    private final String[] extensions;
    private final String mimeType;

    public static ImageFormat getByExtension(String extension) {
        ImageFormat[] values;
        for (ImageFormat imageFormat : values = ImageFormat.values()) {
            String[] formatExtensions;
            for (String formatExtension : formatExtensions = imageFormat.getExtensions()) {
                if (!formatExtension.equals(extension)) continue;
                return imageFormat;
            }
        }
        return null;
    }

    private ImageFormat(String[] extensions, String mimeType) {
        this.extensions = extensions;
        this.mimeType = mimeType;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

