/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir;

import de.digitalcollections.iiif.hymir.cli.Cli;
import de.digitalcollections.iiif.hymir.cli.CliException;
import java.io.PrintWriter;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UrlPathHelper;

@SpringBootApplication
@EnableAutoConfiguration
public class Application
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
        Application.processArguments(args);
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Application.class});
        builder.banner(Application.hymirBanner());
        builder.run(args);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        urlPathHelper.setUrlDecode(false);
        configurer.setUrlPathHelper(urlPathHelper);
    }

    private static Banner hymirBanner() {
        ClassPathResource resource = new ClassPathResource("banner.txt");
        return new ResourceBanner((Resource)resource);
    }

    private static void processArguments(String[] args) {
        try {
            Cli cli = new Cli(new PrintWriter(System.out), args);
            if (cli.hasExitStatus()) {
                System.exit(cli.getExitStatus());
            }
            if (cli.hasRulesPath()) {
                System.setProperty("multiPatternResolvingFile", cli.getRulesPath());
            }
            if (cli.hasSpringProfiles()) {
                System.setProperty("spring.profiles.active", cli.getSpringProfiles());
            }
        }
        catch (CliException e) {
            LOGGER.error(e.getMessage());
            System.exit(1);
        }
        catch (ParseException e) {
            LOGGER.error("Could not parse command line arguments", (Throwable)e);
            System.exit(1);
        }
    }
}

