/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.frontend;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ViewController {
    @Autowired
    @Value(value="#{iiifVersions}")
    private Map<String, String> iiifVersions;

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    public String viewHomepage(Model model) {
        model.addAttribute("menu", (Object)"home");
        return "index";
    }

    @RequestMapping(value={"/image/{identifier}/view.html"}, method={RequestMethod.GET})
    public String viewImageGet(@PathVariable String identifier, Model model) {
        model.addAttribute("iiifVersions", this.iiifVersions);
        model.addAttribute("infoUrl", (Object)("/image/v2/" + identifier + "/info.json"));
        return "openseadragon/view";
    }

    @RequestMapping(value={"/image/view"}, method={RequestMethod.POST})
    public String viewImagePost(@RequestParam String identifier) {
        return "redirect:/image/" + identifier + "/view.html";
    }

    @RequestMapping(value={"/presentation/view"}, method={RequestMethod.POST})
    public String viewPresentationPost(@RequestParam String identifier, Model model) {
        return "redirect:/presentation/view/" + identifier;
    }

    @RequestMapping(value={"/presentation/view/{identifier}"}, method={RequestMethod.GET})
    public String viewPresentationGet(@PathVariable String identifier, Model model) {
        model.addAttribute("iiifVersions", this.iiifVersions);
        model.addAttribute("presentationUri", (Object)("/presentation/v2/" + identifier));
        return "mirador/view";
    }

    @RequestMapping(value={"/presentation/manifest"}, method={RequestMethod.GET})
    public String viewPresentationManifest(@RequestParam String identifier) {
        return "redirect:/presentation/v2/" + identifier + "/manifest";
    }

    @RequestMapping(value={"/presentation/collection"}, method={RequestMethod.GET})
    public String viewPresentationCollection(@RequestParam String name) {
        return "redirect:/presentation/v2/collection/" + name;
    }
}

