/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.backend;

import de.digitalcollections.core.business.api.ResourceService;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.Resource;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import de.digitalcollections.iiif.hymir.model.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.backend.api.PresentationRepository;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PresentationRepositoryImpl
implements PresentationRepository {
    private static final String COLLECTION_PREFIX = "collection-";
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationRepositoryImpl.class);
    @Autowired
    private IiifObjectMapper objectMapper;
    @Autowired
    private ResourceService resourceService;

    @Override
    public Collection getCollection(String name) throws ResolvingException {
        String collectionName = COLLECTION_PREFIX + name;
        try {
            Resource resource = this.resourceService.get(collectionName, ResourcePersistenceType.REFERENCED, MimeType.MIME_APPLICATION_JSON);
            return (Collection)this.objectMapper.readValue(this.getResourceJson(resource.getUri()), Collection.class);
        }
        catch (IOException ex) {
            LOGGER.info("Could not retrieve collection {}", (Object)collectionName, (Object)ex);
            throw new ResolvingException("No collection for name " + collectionName);
        }
    }

    @Override
    public Manifest getManifest(String identifier) throws ResolvingException {
        try {
            Resource resource = this.resourceService.get(identifier, ResourcePersistenceType.REFERENCED, MimeType.MIME_APPLICATION_JSON);
            return (Manifest)this.objectMapper.readValue(this.getResourceJson(resource.getUri()), Manifest.class);
        }
        catch (IOException ex) {
            LOGGER.info("Error getting manifest for identifier " + identifier, (Throwable)ex);
            throw new ResolvingException("No manifest for identifier " + identifier);
        }
    }

    @Override
    public Instant getManifestModificationDate(String identifier) throws ResolvingException {
        return this.getResourceModificationDate(identifier);
    }

    @Override
    public Instant getCollectionModificationDate(String identifier) throws ResolvingException {
        return this.getResourceModificationDate(identifier);
    }

    private Instant getResourceModificationDate(String identifier) throws ResolvingException {
        try {
            Resource resource = this.resourceService.get(identifier, ResourcePersistenceType.REFERENCED, MimeType.MIME_APPLICATION_JSON);
            return Instant.ofEpochMilli(resource.getLastModified());
        }
        catch (ResourceIOException ex) {
            throw new ResolvingException("No manifest for identifier " + identifier);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResourceJson(URI resourceUri) throws ResolvingException {
        try (InputStream is = this.resourceService.getInputStream(resourceUri);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new ResolvingException(e);
        }
    }
}

