/*
 * Decompiled with CFR 0.152.
 */
package de.frachtwerk.essencium.backend.service;

import de.frachtwerk.essencium.backend.model.Role;
import de.frachtwerk.essencium.backend.model.User;
import de.frachtwerk.essencium.backend.model.dto.AppUserDto;
import de.frachtwerk.essencium.backend.repository.BaseUserRepository;
import de.frachtwerk.essencium.backend.repository.UserRepository;
import de.frachtwerk.essencium.backend.service.AbstractUserService;
import de.frachtwerk.essencium.backend.service.JwtTokenService;
import de.frachtwerk.essencium.backend.service.RoleService;
import de.frachtwerk.essencium.backend.service.UserMailService;
import jakarta.validation.constraints.NotNull;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService
extends AbstractUserService<User, Long, AppUserDto> {
    protected UserService(@NotNull UserRepository userRepository, @NotNull PasswordEncoder passwordEncoder, @NotNull UserMailService userMailService, @NotNull RoleService roleService, @NotNull JwtTokenService jwtTokenService) {
        super((BaseUserRepository)userRepository, passwordEncoder, userMailService, roleService, jwtTokenService);
    }

    @NotNull
    protected <E extends AppUserDto> User convertDtoToEntity(@NotNull E entity) {
        Role role = this.roleService.getById(entity.getRole());
        return ((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)((User.UserBuilder)User.builder().email(entity.getEmail())).enabled(entity.isEnabled())).role(role)).firstName(entity.getFirstName())).lastName(entity.getLastName())).locale(entity.getLocale())).mobile(entity.getMobile())).phone(entity.getPhone())).source(entity.getSource())).id((Long)entity.getId()).loginDisabled(entity.isLoginDisabled())).build();
    }

    public AppUserDto getNewUser() {
        return new AppUserDto();
    }
}

