/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.captures;

import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.util.RbelException;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapStat;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.TcpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCapCapture
extends RbelCapturer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PCapCapture.class);
    private String deviceName;
    private String pcapFile;
    private String filter;
    private boolean printMessageToSystemOut;
    private Thread captureThread;
    private PcapHandle handle;
    private PcapDumper dumper;
    private List<TcpPacket> unhandledTcpRequests = new ArrayList<TcpPacket>();
    private List<TcpPacket> unhandledTcpResponses = new ArrayList<TcpPacket>();
    private int tcpServerPort = -1;
    private int packetReceived = 0;
    private int tcpPacketReceived = 0;

    public PCapCapture(RbelConverter rbelConverter, String deviceName, String pcapFile, String filter, boolean printMessageToSystemOut) {
        super(rbelConverter);
        this.deviceName = deviceName;
        this.pcapFile = pcapFile;
        this.filter = filter;
        this.printMessageToSystemOut = printMessageToSystemOut;
    }

    private static void setWindowsNpcapPath() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            Object prop = System.getProperty("jna.library.path");
            prop = prop == null || ((String)prop).isEmpty() ? "C:/Windows/System32/Npcap" : (String)prop + ";C:/Windows/System32/Npcap";
            System.setProperty("jna.library.path", (String)prop);
        }
    }

    @Override
    public RbelCapturer initialize() {
        PCapCapture.setWindowsNpcapPath();
        this.preparePcapHandle();
        this.prepareFilter();
        RBelPacketListener packetListener = new RBelPacketListener(this.handle, this.dumper);
        if (this.pcapFile != null) {
            this.readPcapFile(packetListener);
        } else {
            this.startLiveCaptureThread(packetListener);
        }
        return this;
    }

    private void prepareFilter() {
        if (this.filter == null) {
            this.filter = "host 127.0.0.1 and tcp port 8080";
        }
        log.info("Applying filter '" + this.filter + "'");
    }

    private void preparePcapHandle() {
        if (this.pcapFile != null) {
            this.getOfflinePcapHandle();
        } else if (this.deviceName != null) {
            this.getOnlineHandle();
        } else {
            throw new IllegalArgumentException("Either device or pcap file must be specified");
        }
        if (!this.handle.isOpen()) {
            throw new RuntimeException("Source not open for reading!");
        }
    }

    private void readPcapFile(RBelPacketListener packetListener) {
        while (this.handle.isOpen()) {
            try {
                packetListener.gotPacket(this.handle.getNextPacketEx());
                log.trace("Read-In loop. Currently there are {} request and {} response TCP-Packets in their respective buffers.", (Object)this.unhandledTcpRequests.size(), (Object)this.unhandledTcpResponses.size());
            }
            catch (EOFException e) {
                log.info("Reached EOF");
                break;
            }
            catch (TimeoutException | NotOpenException | PcapNativeException e) {
                throw new RuntimeException(e);
            }
        }
        log.trace("After loop");
    }

    private void startLiveCaptureThread(RBelPacketListener packetListener) {
        this.captureThread = new Thread(() -> {
            try {
                this.handle.setFilter(this.filter, BpfProgram.BpfCompileMode.OPTIMIZE);
                int maxPackets = -1;
                this.handle.loop(-1, (PacketListener)packetListener);
            }
            catch (InterruptedException e) {
                log.info("Packet capturing interrupted...");
                Thread.currentThread().interrupt();
            }
            catch (NotOpenException | PcapNativeException e) {
                throw new RuntimeException(e);
            }
        });
        this.captureThread.start();
    }

    private void getOnlineHandle() {
        try {
            this.getLivePcapHandle();
            this.dumper = this.handle.dumpOpen("out.pcap");
        }
        catch (NotOpenException | PcapNativeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.pcapFile != null) {
            this.initialize();
            return;
        }
        try {
            this.captureThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.handle.breakLoop();
        }
        catch (NotOpenException notOpenException) {
            // empty catch block
        }
        this.tryToPrintStats();
        this.handle.close();
        if (this.dumper != null) {
            this.dumper.close();
        }
    }

    private void tryToPrintStats() {
        if (this.deviceName != null && this.printMessageToSystemOut) {
            try {
                PcapStat stats = this.handle.getStats();
                log.info("Packets received: " + stats.getNumPacketsReceived());
                log.info("Packets dropped: " + stats.getNumPacketsDropped());
                log.info("Packets dropped by interface: " + stats.getNumPacketsDroppedByIf());
                if (SystemUtils.IS_OS_WINDOWS) {
                    log.info("Packets captured: " + stats.getNumPacketsCaptured());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getLivePcapHandle() {
        log.info("Capturing traffic live from device " + this.deviceName);
        PcapNetworkInterface device = Pcaps.getDevByName((String)this.deviceName);
        int snapshotLength = 65536;
        int readTimeout = 50;
        this.handle = device.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 50);
    }

    private void getOfflinePcapHandle() {
        log.info("Reading traffic from pcap file " + new File(this.pcapFile).getAbsolutePath());
        try {
            this.handle = Pcaps.openOffline((String)this.pcapFile, (PcapHandle.TimestampPrecision)PcapHandle.TimestampPrecision.NANO);
        }
        catch (PcapNativeException e) {
            try {
                this.handle = Pcaps.openOffline((String)this.pcapFile);
            }
            catch (PcapNativeException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private byte[] getCurrentBuffer(List<TcpPacket> requestList) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        requestList.stream().sorted(Comparator.comparing(tcpPacket -> tcpPacket.getHeader().getSequenceNumber())).map(Packet::getPayload).map(Packet::getRawData).forEach(data -> {
            try {
                outputStream.write((byte[])data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return outputStream.toByteArray();
    }

    @Generated
    public static PCapCaptureBuilder builder() {
        return new PCapCaptureBuilder();
    }

    @Generated
    public static class PCapCaptureBuilder {
        @Generated
        private RbelConverter rbelConverter;
        @Generated
        private String deviceName;
        @Generated
        private String pcapFile;
        @Generated
        private String filter;
        @Generated
        private boolean printMessageToSystemOut;

        @Generated
        PCapCaptureBuilder() {
        }

        @Generated
        public PCapCaptureBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        @Generated
        public PCapCaptureBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        @Generated
        public PCapCaptureBuilder pcapFile(String pcapFile) {
            this.pcapFile = pcapFile;
            return this;
        }

        @Generated
        public PCapCaptureBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Generated
        public PCapCaptureBuilder printMessageToSystemOut(boolean printMessageToSystemOut) {
            this.printMessageToSystemOut = printMessageToSystemOut;
            return this;
        }

        @Generated
        public PCapCapture build() {
            return new PCapCapture(this.rbelConverter, this.deviceName, this.pcapFile, this.filter, this.printMessageToSystemOut);
        }

        @Generated
        public String toString() {
            return "PCapCapture.PCapCaptureBuilder(rbelConverter=" + this.rbelConverter + ", deviceName=" + this.deviceName + ", pcapFile=" + this.pcapFile + ", filter=" + this.filter + ", printMessageToSystemOut=" + this.printMessageToSystemOut + ")";
        }
    }

    class RBelPacketListener
    implements PacketListener {
        private static final String CONTENT_LENGTH_HEADER_START = "Content-Length: ";
        private final PcapHandle handle;
        private final PcapDumper dumper;

        public void gotPacket(Packet packet) {
            Optional<TcpPacket> tcpPacket = this.extractTcpPacket(packet);
            if (PCapCapture.this.tcpServerPort == -1 && tcpPacket.isPresent() && tcpPacket.get().getHeader().getSyn() && !tcpPacket.get().getHeader().getAck()) {
                PCapCapture.this.tcpServerPort = tcpPacket.get().getHeader().getDstPort().valueAsInt();
            }
            ++PCapCapture.this.packetReceived;
            if (tcpPacket.isEmpty() || tcpPacket.get().getPayload() == null) {
                return;
            }
            ++PCapCapture.this.tcpPacketReceived;
            Pair<RbelHostname, RbelHostname> ipAddresses = this.getIpAddresses(packet);
            if (tcpPacket.get().getHeader().getDstPort().valueAsInt() == PCapCapture.this.tcpServerPort) {
                this.addToBufferAndExtractCompletedMessages(tcpPacket, PCapCapture.this.unhandledTcpRequests, (RbelHostname)ipAddresses.getKey(), (RbelHostname)ipAddresses.getValue());
            } else {
                this.addToBufferAndExtractCompletedMessages(tcpPacket, PCapCapture.this.unhandledTcpResponses, (RbelHostname)ipAddresses.getKey(), (RbelHostname)ipAddresses.getValue());
            }
            if (PCapCapture.this.tcpPacketReceived % 1000 == 0) {
                log.info("Received {} TCP-Packets from {} packets overall", (Object)PCapCapture.this.tcpPacketReceived, (Object)PCapCapture.this.packetReceived);
            }
            try {
                if (this.dumper != null) {
                    this.dumper.dump(packet, this.handle.getTimestamp());
                }
            }
            catch (NotOpenException e) {
                throw new RuntimeException("Encountered exception while receiving", e);
            }
        }

        private Pair<RbelHostname, RbelHostname> getIpAddresses(Packet packet) {
            Optional<Object> srcPort = Optional.empty();
            Optional<Object> srcIpAddress = Optional.empty();
            Optional<Object> dstPort = Optional.empty();
            Optional<Object> dstIpAddress = Optional.empty();
            do {
                if (packet instanceof IpV4Packet) {
                    dstIpAddress = Optional.of(((IpV4Packet)packet).getHeader().getDstAddr().getHostAddress());
                    srcIpAddress = Optional.of(((IpV4Packet)packet).getHeader().getSrcAddr().getHostAddress());
                }
                if (!(packet instanceof TcpPacket)) continue;
                dstPort = Optional.of(((TcpPacket)packet).getHeader().getDstPort().valueAsInt());
                srcPort = Optional.of(((TcpPacket)packet).getHeader().getSrcPort().valueAsInt());
            } while ((packet = packet.getPayload()).getPayload() != null);
            if (srcPort.isEmpty() || srcIpAddress.isEmpty() || dstPort.isEmpty() || dstIpAddress.isEmpty()) {
                throw new RbelException("Error while trying to gather src/dst Data from " + packet);
            }
            return Pair.of((Object)new RbelHostname((String)srcIpAddress.get(), (Integer)srcPort.get()), (Object)new RbelHostname((String)dstIpAddress.get(), (Integer)dstPort.get()));
        }

        private void addToBufferAndExtractCompletedMessages(Optional<TcpPacket> tcpPacket, List<TcpPacket> buffer, RbelHostname sender, RbelHostname recipient) {
            tcpPacket.ifPresent(buffer::add);
            Optional<byte[]> nextMessage = this.extractCompleteHttpMessage(PCapCapture.this.getCurrentBuffer(buffer));
            if (nextMessage.isPresent()) {
                this.processSimpleHttpPackets(nextMessage.get(), sender, recipient);
                buffer.clear();
            }
        }

        private Optional<byte[]> extractCompleteHttpMessage(byte[] currentBuffer) {
            String dumpString = new String(currentBuffer, StandardCharsets.US_ASCII);
            if (!this.isHttp(dumpString)) {
                log.trace("No HTTP-message recognized, skipping");
                return Optional.empty();
            }
            String[] messageParts = dumpString.split("\r\n\r\n");
            String[] headerFields = messageParts[0].split("\r\n");
            Optional<Integer> messageLength = Stream.of(headerFields).filter(field -> field.startsWith(CONTENT_LENGTH_HEADER_START)).map(field -> field.substring(CONTENT_LENGTH_HEADER_START.length())).filter(NumberUtils::isParsable).map(Integer::parseInt).findAny();
            if (messageLength.isPresent()) {
                if (messageParts.length < 2) {
                    if (messageLength.isEmpty() || messageLength.get() == 0) {
                        return Optional.of(currentBuffer);
                    }
                    log.trace("Header found, body segmented away. \n'{}'", (Object)dumpString);
                    return Optional.empty();
                }
                if (messageParts[1].length() == messageLength.get().intValue() || messageParts[1].length() == messageLength.get() + 1) {
                    return Optional.of(currentBuffer);
                }
                if (messageParts[1].length() > messageLength.get()) {
                    throw new RuntimeException("Overshot while parsing message (collected more bytes then the message has)");
                }
                log.trace("Message not yet complete. Wanted {} bytes, but found only {}", (Object)messageLength.get(), (Object)messageParts[1].length());
                return Optional.empty();
            }
            boolean chunked = Arrays.asList(headerFields).contains("Transfer-Encoding: chunked");
            if (!chunked) {
                log.trace("Returning (hopefully) body-less message");
                return Optional.of(currentBuffer);
            }
            if (!dumpString.endsWith("0\r\n\r\n")) {
                log.trace("Chunked message, incomplete");
                return Optional.empty();
            }
            log.trace("Returning chunked message");
            return Optional.ofNullable(currentBuffer);
        }

        private Optional<TcpPacket> extractTcpPacket(Packet packet) {
            Packet ptr;
            for (ptr = packet; ptr != null && !(ptr instanceof TcpPacket); ptr = ptr.getPayload()) {
            }
            if (ptr instanceof TcpPacket) {
                return Optional.ofNullable((TcpPacket)ptr);
            }
            return Optional.empty();
        }

        private void processSimpleHttpPackets(byte[] content, RbelHostname sender, RbelHostname recipient) {
            RbelElement convertedMessage = PCapCapture.this.getRbelConverter().parseMessage(content, sender, recipient);
            if (PCapCapture.this.printMessageToSystemOut && convertedMessage != null && content.length > 0) {
                if (convertedMessage.getRawStringContent() != null) {
                    log.trace("RBEL: " + convertedMessage.getRawStringContent());
                } else {
                    log.trace("RBEL: <null> message encountered!");
                }
            }
        }

        private boolean isHttp(String content) {
            return this.isHttpRequest(content) || this.isHttpResponse(content);
        }

        private boolean isHttpResponse(String content) {
            return content.startsWith("HTTP/");
        }

        private boolean isHttpRequest(String content) {
            return this.isGetOrDeleteRequest(content) || this.isPostOrPutRequest(content);
        }

        private boolean isGetOrDeleteRequest(String content) {
            return content.startsWith("GET ") || content.startsWith("DELETE ");
        }

        private boolean isPostOrPutRequest(String content) {
            return content.startsWith("POST ") || content.startsWith("PUT ");
        }

        @ConstructorProperties(value={"handle", "dumper"})
        @Generated
        public RBelPacketListener(PcapHandle handle, PcapDumper dumper) {
            this.handle = handle;
            this.dumper = dumper;
        }
    }
}

