/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelVauEpaFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelVauEpaConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauEpaConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConverter context) {
        log.trace("Trying to decipher '{}'...", (Object)element.getRawStringContent());
        this.tryToExtractRawVauContent(element).flatMap(content -> this.decipherVauMessage((byte[])content, context, element)).ifPresent(vauMsg -> {
            element.addFacet((RbelFacet)vauMsg);
            element.addFacet(new RbelRootFacet<RbelVauEpaFacet>((RbelVauEpaFacet)vauMsg));
            context.convertElement(vauMsg.getMessage());
        });
    }

    private Optional<byte[]> tryToExtractRawVauContent(RbelElement element) {
        if (element.getParentNode() != null && element.getParentNode().hasFacet(RbelJsonFacet.class)) {
            try {
                return Optional.ofNullable(Base64.getDecoder().decode(element.getRawContent()));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(element.getRawContent());
    }

    private Optional<RbelVauEpaFacet> decipherVauMessage(byte[] content, RbelConverter converter, RbelElement parentNode) {
        Optional<Pair<byte[], byte[]>> splitOptional = this.splitVauMessage(content);
        if (splitOptional.isEmpty()) {
            return Optional.empty();
        }
        Pair<byte[], byte[]> splitVauMessage = splitOptional.get();
        List potentialVauKeys = converter.getRbelKeyManager().getAllKeys().filter(key -> key.getKeyName().startsWith(Hex.toHexString((byte[])((byte[])splitVauMessage.getKey())))).filter(key -> key.getKey() instanceof SecretKey).collect(Collectors.toList());
        for (RbelKey rbelKey : potentialVauKeys) {
            Optional<byte[]> decryptedBytes = CryptoUtils.decrypt((byte[])splitVauMessage.getValue(), rbelKey.getKey(), 12, 16);
            if (!decryptedBytes.isPresent()) continue;
            try {
                log.trace("Succesfully deciphered VAU message! ({})", (Object)new String(decryptedBytes.get()));
                return this.buildVauMessageFromCleartext(converter, splitVauMessage, decryptedBytes.get(), parentNode, rbelKey);
            }
            catch (RuntimeException e) {
                log.error("Exception while building cleartext VAU message:", (Throwable)e);
                throw new RbelConversionException("Exception while building cleartext VAU message", e);
            }
        }
        return Optional.empty();
    }

    private Optional<RbelVauEpaFacet> buildVauMessageFromCleartext(RbelConverter converter, Pair<byte[], byte[]> splitVauMessage, byte[] decryptedBytes, RbelElement parentNode, RbelKey rbelKey) {
        String cleartextString = new String(decryptedBytes);
        if (cleartextString.startsWith("VAUClientSigFin") || cleartextString.startsWith("VAUServerFin")) {
            RbelElement decryptedPayload = new RbelElement(decryptedBytes, parentNode);
            decryptedPayload.addFacet(new RbelBinaryFacet());
            return Optional.of(RbelVauEpaFacet.builder().message(converter.filterInputThroughPreConversionMappers(decryptedPayload)).encryptedMessage(RbelElement.wrap(parentNode, splitVauMessage.getValue())).keyIdUsed(RbelElement.wrap(parentNode, rbelKey.getKeyName().split("_")[0])).keyUsed(Optional.of(rbelKey)).build());
        }
        return Optional.of(this.fromRaw(splitVauMessage, converter, decryptedBytes, parentNode, rbelKey));
    }

    private RbelVauEpaFacet fromRaw(Pair<byte[], byte[]> payloadPair, RbelConverter converter, byte[] decryptedBytes, RbelElement parentNode, RbelKey rbelKey) {
        byte[] raw = new byte[decryptedBytes.length - 8 - 1];
        System.arraycopy(decryptedBytes, 9, raw, 0, raw.length);
        byte[] sequenceNumberBytes = new byte[4];
        System.arraycopy(decryptedBytes, 5, sequenceNumberBytes, 0, 4);
        int sequenceNumber = ByteBuffer.wrap(sequenceNumberBytes).getInt();
        byte[] numberOfBytes_inBytes = new byte[4];
        System.arraycopy(raw, 0, numberOfBytes_inBytes, 0, 4);
        int numberOfBytes = ByteBuffer.wrap(numberOfBytes_inBytes).getInt();
        byte[] headerField_inBytes = new byte[numberOfBytes];
        System.arraycopy(raw, 4, headerField_inBytes, 0, numberOfBytes);
        String headerField = new String(headerField_inBytes, StandardCharsets.US_ASCII);
        RbelElement headerElement = new RbelElement(headerField_inBytes, parentNode);
        RbelHttpHeaderFacet header = new RbelHttpHeaderFacet();
        headerElement.addFacet(header);
        Arrays.stream(headerField.split("\r\n")).map(field -> field.split(":", 2)).forEach(field -> header.put(field[0].trim(), converter.convertElement(field[1], headerElement)));
        byte[] body = new byte[raw.length - 4 - numberOfBytes];
        System.arraycopy(raw, 4 + numberOfBytes, body, 0, body.length);
        return RbelVauEpaFacet.builder().message(converter.filterInputThroughPreConversionMappers(new RbelElement(body, parentNode))).additionalHeaders(headerElement).encryptedMessage(RbelElement.wrap((byte[])payloadPair.getValue(), parentNode, null)).keyIdUsed(RbelElement.wrap(parentNode, Hex.toHexString((byte[])((byte[])payloadPair.getKey())))).pVersionNumber(RbelElement.wrap(parentNode, decryptedBytes[0])).sequenceNumber(RbelElement.wrap(parentNode, sequenceNumber)).keyUsed(Optional.ofNullable(rbelKey)).build();
    }

    private Optional<Pair<byte[], byte[]>> splitVauMessage(byte[] vauMessage) {
        try {
            byte[] keyID = new byte[32];
            System.arraycopy(vauMessage, 0, keyID, 0, 32);
            byte[] enc = new byte[vauMessage.length - 32];
            System.arraycopy(vauMessage, 32, enc, 0, vauMessage.length - 32);
            return Optional.of(Pair.of((Object)keyID, (Object)enc));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }
}

