/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RbelHttpHeaderFacet
implements RbelFacet,
Map<String, RbelElement> {
    private final RbelMultiMap values;

    public RbelHttpHeaderFacet() {
        this.values = new RbelMultiMap();
    }

    public RbelHttpHeaderFacet(RbelMultiMap values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsKey(value);
    }

    @Override
    public RbelElement get(Object key) {
        return this.values.get(key);
    }

    @Override
    public RbelElement put(String key, RbelElement value) {
        this.values.put(key, value);
        return value;
    }

    @Override
    public RbelElement remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends RbelElement> m) {
        this.values.putAll(m);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public List<RbelElement> values() {
        return this.values.stream().map(Map.Entry::getValue).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Deprecated
    public Set<Map.Entry<String, RbelElement>> entrySet() {
        return this.values.entrySet();
    }

    public List<Map.Entry<String, RbelElement>> entries() {
        return this.values.getValues();
    }

    @Override
    public RbelMultiMap getChildElements() {
        return this.values;
    }

    public Stream<RbelElement> getCaseInsensitiveMatches(String key) {
        String lowerCaseKey = key.toLowerCase();
        return this.values.getValues().stream().filter(entry -> entry.getKey() != null).filter(entry -> ((String)entry.getKey()).toLowerCase().equals(lowerCaseKey)).map(Map.Entry::getValue);
    }

    public boolean hasValueMatching(String headerKey, String prefix) {
        return this.values.getValues().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(headerKey)).map(Map.Entry::getValue).map(RbelElement::getRawStringContent).anyMatch(str -> str.startsWith(prefix));
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelHttpHeaderFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                return ((ContainerTag)TagCreator.table().withClass("table")).with(new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"name"), TagCreator.th((String)"value")})}), TagCreator.tbody().with((Iterable)element.getFacetOrFail(RbelHttpHeaderFacet.class).getChildElements().stream().map(entry -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.pre((String)((String)entry.getKey()))}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.pre().with((DomContent)renderingToolkit.convert((RbelElement)entry.getValue(), Optional.ofNullable((String)entry.getKey()))).withClass("value")}).with(RbelHtmlRenderingToolkit.addNotes((RbelElement)entry.getValue(), new String[0]))})).collect(Collectors.toList()))});
            }
        });
    }
}

