/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.sicct;

import de.gematik.rbellogger.data.RbelElement;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

public enum RbelSicctCommand {
    SICCT_RESET(-128, 17),
    SICCT_REQUEST(-128, 18),
    SICCT_GET_STATUS(-128, 19),
    SICCT_EJECT(-128, 21),
    SICCT_INPUT(-128, 22),
    SICCT_OUTPUT(-128, 23),
    SICCT_PERFORM_VERIFICATION(-128, 24),
    SICCT_MODIFY_VERIFICATION_DATA(-128, 25),
    SICCT_SELECT_CT_MODE(-128, 32),
    SICCT_COMFORT_AUTHENTICATION(-128, 33),
    SICCT_COMFORT_ENROLL(-128, 34),
    SICCT_SET_STATUS(8, 35),
    SICCT_DOWNLOAD_INIT(-128, 36),
    SICCT_DOWNLOAD_DATA(-128, 37),
    SICCT_DOWNLOAD_FINISH(-128, 38),
    SICCT_CONTROLCOMMAND(-128, 39),
    SICCT_INIT_CT_SESSION(-128, 40),
    SICCT_CLOSE_CT_SESSION(-128, 41);

    final byte cla;
    final byte ins;

    public static Optional<RbelSicctCommand> from(RbelElement cla, RbelElement ins) {
        return Stream.of(RbelSicctCommand.values()).filter(cmd -> cla.getRawContent() != null && cla.getRawContent().length == 1).filter(cmd -> cla.getRawContent()[0] == cmd.cla).filter(cmd -> ins.getRawContent() != null && ins.getRawContent().length == 1).filter(cmd -> ins.getRawContent()[0] == cmd.ins).findAny();
    }

    @ConstructorProperties(value={"cla", "ins"})
    @Generated
    private RbelSicctCommand(byte cla, byte ins) {
        this.cla = cla;
        this.ins = ins;
    }
}

