/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJweEncryptionInfo;
import de.gematik.rbellogger.data.facet.RbelJweFacet;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import de.gematik.rbellogger.util.JsonUtils;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

public class RbelJweWriter
implements RbelElementWriter {
    private final RbelKeyManager rbelKeyManager;

    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelJweFacet.class);
    }

    @Override
    public byte[] write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent) {
        RbelJweFacet rbelJweFacet = oldTargetElement.getFacetOrFail(RbelJweFacet.class);
        return this.createUpdatedJwe(oldTargetModifiedChild, new String(newContent, StandardCharsets.UTF_8), rbelJweFacet).getBytes(StandardCharsets.UTF_8);
    }

    private String createUpdatedJwe(RbelElement oldTargetModifiedChild, String newContent, RbelJweFacet rbelJweFacet) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        this.writeHeaderInJwe(oldTargetModifiedChild, newContent, rbelJweFacet, jwe);
        jwe.setPayload(this.extractJweBodyClaims(oldTargetModifiedChild, newContent, rbelJweFacet));
        jwe.setKey(this.extractJweKey(rbelJweFacet).getKey());
        try {
            return jwe.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new JweUpdateException("Error writing into Jwe", e);
        }
    }

    private RbelKey extractJweKey(RbelJweFacet rbelJweFacet) {
        return (RbelKey)rbelJweFacet.getEncryptionInfo().getFacet(RbelJweEncryptionInfo.class).map(RbelJweEncryptionInfo::getDecryptedUsingKeyWithId).filter(obj -> Objects.nonNull(obj)).flatMap(this.rbelKeyManager::findKeyByName).flatMap(RbelKey::getMatchingPublicKey).orElseThrow(() -> new InvalidEncryptionInfo("Could not find matching public key to \n" + rbelJweFacet.getEncryptionInfo().printTreeStructure()));
    }

    private void writeHeaderInJwe(RbelElement oldTargetModifiedChild, String newContent, RbelJweFacet rbelJweFacet, JsonWebEncryption jwe) {
        this.extractJweHeaderClaim(oldTargetModifiedChild, newContent, rbelJweFacet).forEach(pair -> jwe.setHeader((String)pair.getKey(), (String)pair.getValue()));
    }

    private List<Map.Entry<String, String>> extractJweHeaderClaim(RbelElement oldTargetModifiedChild, String newContent, RbelJweFacet rbelJweFacet) {
        if (rbelJweFacet.getHeader() == oldTargetModifiedChild) {
            return JsonUtils.convertJsonObjectStringToMap(newContent);
        }
        return JsonUtils.convertJsonObjectStringToMap(rbelJweFacet.getHeader().getRawStringContent());
    }

    private String extractJweBodyClaims(RbelElement oldTargetModifiedChild, String newContent, RbelJweFacet jweFacet) {
        if (jweFacet.getBody() == oldTargetModifiedChild) {
            return newContent;
        }
        return jweFacet.getBody().getRawStringContent();
    }

    @ConstructorProperties(value={"rbelKeyManager"})
    @Generated
    public RbelJweWriter(RbelKeyManager rbelKeyManager) {
        this.rbelKeyManager = rbelKeyManager;
    }

    static {
        BrainpoolCurves.init();
    }

    public class InvalidEncryptionInfo
    extends RuntimeException {
        public InvalidEncryptionInfo(String s) {
            super(s);
        }
    }

    public class JweUpdateException
    extends RuntimeException {
        public JweUpdateException(String s, JoseException e) {
            super(s, e);
        }
    }
}

