/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.geom;

import java.util.Objects;
import net.openstreetcraft.api.geom.Point;

public class BoundingBox {
    private final Point upperLeft;
    private final Point upperRight;
    private final Point lowerLeft;
    private final Point lowerRight;

    protected BoundingBox(Builder builder) {
        this.upperLeft = Objects.requireNonNull(builder.upperLeft);
        this.upperRight = Objects.requireNonNull(builder.upperRight);
        this.lowerLeft = Objects.requireNonNull(builder.lowerLeft);
        this.lowerRight = Objects.requireNonNull(builder.lowerRight);
    }

    public int hashCode() {
        return Objects.hash(this.upperLeft, this.upperRight, this.lowerLeft, this.lowerRight);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        return Objects.equals(this.upperLeft, other.upperLeft) && Objects.equals(this.upperRight, other.upperRight) && Objects.equals(this.lowerLeft, other.lowerLeft) && Objects.equals(this.lowerRight, other.lowerRight);
    }

    public String toString() {
        return "BoundingBox [upperLeft=" + this.upperLeft + ", upperRight=" + this.upperRight + ", lowerLeft=" + this.lowerLeft + ", lowerRight=" + this.lowerRight + "]";
    }

    public Point getUpperLeft() {
        return this.upperLeft;
    }

    public Point getUpperRight() {
        return this.upperRight;
    }

    public Point getLowerLeft() {
        return this.lowerLeft;
    }

    public Point getLowerRight() {
        return this.lowerRight;
    }

    public static class Builder {
        private Point upperLeft;
        private Point upperRight;
        private Point lowerLeft;
        private Point lowerRight;

        public BoundingBox build() {
            return new BoundingBox(this);
        }

        public Builder withUpperLeft(Point point) {
            this.upperLeft = point;
            return this;
        }

        public Builder withUpperRight(Point point) {
            this.upperRight = point;
            return this;
        }

        public Builder withLowerLeft(Point point) {
            this.lowerLeft = point;
            return this;
        }

        public Builder withLowerRight(Point point) {
            this.lowerRight = point;
            return this;
        }
    }
}

