/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.geom;

import java.util.Objects;

public class Point {
    private final double x;
    private final double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point add(Point summand) {
        return new Point(this.x + summand.x, this.y + summand.y);
    }

    public Point sub(Point subtrahend) {
        return new Point(this.x - subtrahend.x, this.y - subtrahend.y);
    }

    public Point mul(double factor) {
        return new Point(this.x * factor, this.y * factor);
    }

    public Point div(double ratio) {
        return new Point(this.x / ratio, this.y / ratio);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y);
    }

    public String toString() {
        return "Point [x=" + this.x + ", y=" + this.y + "]";
    }
}

