/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.geom;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public class Raster<T> {
    private final int width;
    private final int height;
    private final T[] data;

    @SafeVarargs
    public Raster(int width, int height, T ... data) {
        assert (data.length == width * height);
        this.width = width;
        this.height = height;
        this.data = (Object[])data.clone();
    }

    public <R> Raster<R> convert(Function<T, R> converter) {
        Object[] dest = new Object[this.width * this.height];
        for (int index = 0; index < dest.length; ++index) {
            dest[index] = converter.apply(this.data[index]);
        }
        return new Raster<Object>(this.width, this.height, dest);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Raster)) {
            return false;
        }
        Raster other = (Raster)obj;
        return Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height) && Arrays.equals(this.data, other.data);
    }

    public String toString() {
        return "Raster [width=" + this.width + ", height=" + this.height + ", data=" + Arrays.toString(this.data) + "]";
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public T getSample(int x, int y) {
        Raster.require(x >= 0 && x < this.width);
        Raster.require(y >= 0 && y < this.height);
        return this.data[x + y * this.width];
    }

    private static void require(boolean requirement) {
        if (!requirement) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

