/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.geom;

import net.openstreetcraft.api.geom.BoundingBox;
import net.openstreetcraft.api.geom.Point;

public class RectangularBoundingBox
extends BoundingBox {
    private RectangularBoundingBox(Builder builder) {
        super(RectangularBoundingBox.createParentBuilder(builder));
    }

    private static BoundingBox.Builder createParentBuilder(Builder builder) {
        Point upperLeft = new Point(builder.lowerLeft.getX(), builder.upperRight.getY());
        Point lowerRight = new Point(builder.upperRight.getX(), builder.lowerLeft.getY());
        return new BoundingBox.Builder().withLowerLeft(builder.lowerLeft).withUpperRight(builder.upperRight).withLowerRight(lowerRight).withUpperLeft(upperLeft);
    }

    public static class Builder {
        private Point upperRight;
        private Point lowerLeft;

        public RectangularBoundingBox build() {
            return new RectangularBoundingBox(this);
        }

        public Builder withUpperRight(Point point) {
            this.upperRight = point;
            return this;
        }

        public Builder withLowerLeft(Point point) {
            this.lowerLeft = point;
            return this;
        }
    }
}

