/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.geom;

import java.util.Iterator;
import java.util.Objects;
import net.openstreetcraft.api.geom.BoundingBox;
import net.openstreetcraft.api.geom.Point;

public class RegularGrid
implements Iterable<Point> {
    private final BoundingBox bbox;
    private final int width;
    private final int height;

    public RegularGrid(BoundingBox bbox, int width, int height) {
        this.bbox = bbox;
        this.width = width;
        this.height = height;
    }

    public int hashCode() {
        return Objects.hash(this.bbox, this.width, this.height);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegularGrid)) {
            return false;
        }
        RegularGrid other = (RegularGrid)obj;
        return Objects.equals(this.bbox, other.bbox) && Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height);
    }

    public String toString() {
        return "RegularGrid [bbox=" + this.bbox + ", width=" + this.width + ", height=" + this.height + "]";
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            private int x = 0;
            private int y = 0;
            private Point leftEnd = RegularGrid.access$000(RegularGrid.this).getLowerLeft();
            private Point rightEnd = RegularGrid.access$000(RegularGrid.this).getLowerRight();

            @Override
            public boolean hasNext() {
                return this.x < RegularGrid.this.width && this.y < RegularGrid.this.height;
            }

            @Override
            public Point next() {
                double dx = this.div(this.x, RegularGrid.this.width - 1);
                Point point = this.dividingPoint(this.leftEnd, this.rightEnd, dx);
                this.increment();
                return point;
            }

            private double div(int dividend, int divisor) {
                return divisor == 0 ? 0.5 : (double)dividend / (double)divisor;
            }

            private Point dividingPoint(Point start, Point end, double factor) {
                return end.sub(start).mul(factor).add(start);
            }

            private void increment() {
                ++this.x;
                if (this.x >= RegularGrid.this.width) {
                    this.x = 0;
                    ++this.y;
                    double dy = this.div(this.y, RegularGrid.this.height - 1);
                    this.leftEnd = this.dividingPoint(RegularGrid.this.bbox.getLowerLeft(), RegularGrid.this.bbox.getUpperLeft(), dy);
                    this.rightEnd = this.dividingPoint(RegularGrid.this.bbox.getLowerRight(), RegularGrid.this.bbox.getUpperRight(), dy);
                }
            }
        };
    }
}

