/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.model;

import java.util.function.Function;

public enum Cover {
    IRRIGATED_CROPLANDS(11),
    RAINFED_CROPLANDS(14),
    MOSAIC_CROPLANDS(20),
    MOSAIC_VEGETATION(30),
    BROADLEAVED_EVERGREEN_FOREST(40),
    BROADLEAVED_DECIDUOUS_FOREST(50),
    BROADLEAVED_WOODLAND(60),
    NEEDLELEAVED_EVERGREEN_FOREST(70),
    NEEDLELEAVED_DECIDUOUS_FOREST(90),
    MIXED_FOREST(100),
    MOSAIC_FOREST(110),
    MOSAIC_GRASSLAND(120),
    SHRUBLAND(130),
    HERBACEOUS_VEGETATION(140),
    SPARSE_VEGETATION(150),
    REGULARLY_FLOODED_FOREST(160),
    PERMANENTLY_FLOODED_FOREST(170),
    REGULARLY_FLOODED_VEGETATION(180),
    URBAN(190),
    BARE(200),
    WATER(210),
    ICE(220),
    NO_DATA(230);

    private int sample;

    private Cover(int sample) {
        this.sample = sample;
    }

    private static Cover of(Byte sample) {
        for (Cover cover : Cover.values()) {
            if (cover.sample != Byte.toUnsignedInt(sample)) continue;
            return cover;
        }
        throw new IllegalArgumentException(sample.toString());
    }

    public static class Converter
    implements Function<Byte, Cover> {
        @Override
        public Cover apply(Byte sample) {
            return Cover.of(sample);
        }
    }
}

