/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class MinecraftLocation
implements Comparable<MinecraftLocation> {
    private long x;
    private long z;

    public MinecraftLocation(@JsonProperty(value="x") long x, @JsonProperty(value="z") long z) {
        this.x = x;
        this.z = z;
    }

    private MinecraftLocation(Builder builder) {
        this(builder.x, builder.z);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public boolean equals(Object other) {
        if (other instanceof MinecraftLocation) {
            return this.compareTo((MinecraftLocation)other) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(MinecraftLocation other) {
        int cmp = Long.compare(this.x, other.x);
        return cmp != 0 ? cmp : Long.compare(this.z, other.z);
    }

    public String toString() {
        return "MinecraftLocation [x=" + this.x + ", z=" + this.z + "]";
    }

    public long getX() {
        return this.x;
    }

    public long getZ() {
        return this.z;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long x;
        private long z;

        public MinecraftLocation build() {
            return new MinecraftLocation(this);
        }

        public Builder withX(long x) {
            this.x = x;
            return this;
        }

        public Builder withZ(long z) {
            this.z = z;
            return this;
        }
    }
}

