/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SphericalLocation
implements Comparable<SphericalLocation> {
    private double latitude;
    private double longitude;

    public SphericalLocation(@JsonProperty(value="latitude") double latitude, @JsonProperty(value="longitude") double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    private SphericalLocation(Builder builder) {
        this(builder.latitude, builder.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public boolean equals(Object other) {
        if (other instanceof SphericalLocation) {
            return this.compareTo((SphericalLocation)other) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(SphericalLocation other) {
        int cmp = Double.compare(this.latitude, other.latitude);
        return cmp != 0 ? cmp : Double.compare(this.longitude, other.longitude);
    }

    public String toString() {
        return "SphericalLocation [latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double latitude;
        private double longitude;

        public SphericalLocation build() {
            return new SphericalLocation(this);
        }

        public Builder withLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder withLongitude(double longitude) {
            this.longitude = longitude;
            return this;
        }
    }
}

