/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.rest;

import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
class RestTemplateConfiguration {
    private final ClientHttpRequestFactory requestFactory;

    @Autowired
    public RestTemplateConfiguration(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Bean
    public RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate(this.requestFactory);
        ArrayList<MappingJackson2HttpMessageConverter> converters = new ArrayList<MappingJackson2HttpMessageConverter>(restTemplate.getMessageConverters());
        converters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }
}

