/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.rest.apache;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class CredentialsProviderConfiguration {
    @Value(value="${openstreetcraft.host}")
    private String host;
    @Value(value="${openstreetcraft.port}")
    private String port;
    @Value(value="${openstreetcraft.username:}")
    private String username;
    @Value(value="${openstreetcraft.password:}")
    private String password;

    CredentialsProviderConfiguration() {
    }

    @Bean
    public CredentialsProvider getCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(this.getAuthScope(), this.getCredentials());
        return credentialsProvider;
    }

    private AuthScope getAuthScope() {
        return new AuthScope(this.host, Integer.parseInt(this.port));
    }

    private Credentials getCredentials() {
        return new UsernamePasswordCredentials(this.username, this.password);
    }
}

