/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.rest.apache;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class HttpClientConfiguration {
    private static final int MAX_TOTAL_CONNECTIONS = 10;
    private static final int SOCKET_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(60L);
    private static final int CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int REQUEST_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    @Value(value="${openstreetcraft.protocol}")
    private String protocol;
    @Value(value="${openstreetcraft.host}")
    private String host;
    @Value(value="${openstreetcraft.port}")
    private String port;

    HttpClientConfiguration() {
    }

    @Bean
    public HttpClient getHttpClient(CredentialsProvider credentialsProvider) {
        return CachingHttpClientBuilder.create().setCacheConfig(HttpClientConfiguration.cacheConfig()).setProxy(this.getProxy()).setDefaultCredentialsProvider(credentialsProvider).setDefaultRequestConfig(HttpClientConfiguration.requestConfig()).setConnectionManager(HttpClientConfiguration.connectionManager()).build();
    }

    private static CacheConfig cacheConfig() {
        return CacheConfig.custom().setMaxCacheEntries(1024).setMaxObjectSize(102400L).setNeverCacheHTTP10ResponsesWithQueryString(false).build();
    }

    private HttpHost getProxy() {
        return new HttpHost(this.host, Integer.parseInt(this.port), this.protocol);
    }

    private static RequestConfig requestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(REQUEST_TIMEOUT).setConnectTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
    }

    private static HttpClientConnectionManager connectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(10);
        return connectionManager;
    }
}

