/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.openstreetcraft.api.service.Loader;

public abstract class AbstractLoader<K, V>
implements Loader<K, V> {
    private final List<K> keys = new ArrayList<K>();
    private Map<K, V> cache = new HashMap();

    @Override
    public synchronized void invalidate() {
        this.keys.clear();
        this.cache.clear();
    }

    @Override
    public synchronized void prefetch(K key) {
        this.keys.add(key);
    }

    @Override
    public synchronized V get(K key) {
        if (!this.keys.isEmpty() && !this.cache.containsKey(key)) {
            this.cache = this.fetchAll(this.keys);
        }
        return (V)this.cache.computeIfAbsent(key, k -> this.fetch(k));
    }

    protected Map<K, V> fetchAll(List<K> keys) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : keys) {
            result.put(key, this.fetch(key));
        }
        return result;
    }

    protected abstract V fetch(K var1);

    protected static final <K, V> Map<K, V> combine(List<K> keys, List<V> values) {
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        HashMap<K, V> result = new HashMap<K, V>();
        while (keyIterator.hasNext() || valueIterator.hasNext()) {
            result.put(keyIterator.next(), valueIterator.next());
        }
        return result;
    }
}

