/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.List;
import java.util.Objects;
import net.openstreetcraft.api.model.World;
import net.openstreetcraft.api.service.Cache;
import net.openstreetcraft.api.service.CoordinatesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class CachingCoordinatesService
extends CoordinatesService {
    private final Cache<Key<Long>, List<Double>> sphericalSamplesCache;
    private final Cache<Key<Double>, List<Long>> minecraftSamplesCache;

    @Autowired
    public CachingCoordinatesService(RestTemplate restTemplate, @Value(value="${coordinates.cache:1}") int cacheSize) {
        super(restTemplate);
        this.sphericalSamplesCache = new Cache(cacheSize);
        this.minecraftSamplesCache = new Cache(cacheSize);
    }

    @Override
    protected synchronized List<Double> getSphericalSamples(List<Long> samples, World world) throws RestClientException {
        return this.sphericalSamplesCache.computeIfAbsent(new Key<Long>(samples, world), key -> super.getSphericalSamples(((Key)key).samples, ((Key)key).world));
    }

    @Override
    protected synchronized List<Long> getMinecraftSamples(List<Double> samples, World world) throws RestClientException {
        return this.minecraftSamplesCache.computeIfAbsent(new Key<Double>(samples, world), key -> super.getMinecraftSamples(((Key)key).samples, ((Key)key).world));
    }

    private static class Key<T> {
        private final List<T> samples;
        private final World world;

        Key(List<T> samples, World world) {
            this.samples = samples;
            this.world = world;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.samples, this.world});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.samples, other.samples) && Objects.equals((Object)this.world, (Object)other.world);
        }
    }
}

