/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.Objects;
import net.openstreetcraft.api.geom.Raster;
import net.openstreetcraft.api.geom.RectangularBoundingBox;
import net.openstreetcraft.api.model.Layer;
import net.openstreetcraft.api.model.World;
import net.openstreetcraft.api.service.Cache;
import net.openstreetcraft.api.service.MapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class CachingMapService
extends MapService {
    private final Cache<Key, Raster<Float>> floatSamplesCache;
    private final Cache<Key, Raster<Byte>> byteSamplesCache;

    @Autowired
    public CachingMapService(RestTemplate restTemplate, @Value(value="${map.cache:1}") int cacheSize) {
        super(restTemplate);
        this.floatSamplesCache = new Cache(cacheSize);
        this.byteSamplesCache = new Cache(cacheSize);
    }

    @Override
    public synchronized Raster<Float> getFloatSamples(World world, Layer layer, RectangularBoundingBox bbox, int width, int height) throws RestClientException {
        return this.floatSamplesCache.computeIfAbsent(new Key(world, layer, bbox, width, height), key -> super.getFloatSamples(((Key)key).world, ((Key)key).layer, ((Key)key).bbox, ((Key)key).width, ((Key)key).height));
    }

    @Override
    public synchronized Raster<Byte> getByteSamples(World world, Layer layer, RectangularBoundingBox bbox, int width, int height) throws RestClientException {
        return this.byteSamplesCache.computeIfAbsent(new Key(world, layer, bbox, width, height), key -> super.getByteSamples(((Key)key).world, ((Key)key).layer, ((Key)key).bbox, ((Key)key).width, ((Key)key).height));
    }

    private static class Key {
        private final World world;
        private final Layer layer;
        private final RectangularBoundingBox bbox;
        private final int width;
        private final int height;

        Key(World world, Layer layer, RectangularBoundingBox bbox, int width, int height) {
            this.world = world;
            this.layer = layer;
            this.bbox = bbox;
            this.width = width;
            this.height = height;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.world, this.layer, this.bbox, this.width, this.height});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals((Object)this.world, (Object)other.world) && Objects.equals((Object)this.layer, (Object)other.layer) && Objects.equals(this.bbox, other.bbox) && Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height);
        }
    }
}

