/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import de.ixilon.osm.schema.OsmRoot;
import net.openstreetcraft.api.service.Cache;
import net.openstreetcraft.api.service.OverpassService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class CachingOverpassService
extends OverpassService {
    private final Cache<String, OsmRoot> xapiCache;
    private final Cache<String, OsmRoot> xmlCache;

    @Autowired
    public CachingOverpassService(RestTemplate restTemplate, @Value(value="${overpass.cache:1}") int cacheSize) {
        super(restTemplate);
        this.xapiCache = new Cache(cacheSize);
        this.xmlCache = new Cache(cacheSize);
    }

    @Override
    protected synchronized OsmRoot getOsmRoot(String query) {
        return this.xapiCache.computeIfAbsent(query, key -> super.getOsmRoot((String)key));
    }

    @Override
    protected synchronized OsmRoot postOsmRoot(String query) {
        return this.xmlCache.computeIfAbsent(query, key -> super.postOsmRoot((String)key));
    }
}

