/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openstreetcraft.api.model.MinecraftLocation;
import net.openstreetcraft.api.model.SphericalLocation;
import net.openstreetcraft.api.model.World;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class CoordinatesService {
    private static final String ENDPOINT = "http://COORDINATES/api/v1";
    private final RestTemplate restTemplate;

    @Autowired
    public CoordinatesService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public SphericalLocation getSphericalLocation(MinecraftLocation location, World world) throws RestClientException {
        return CoordinatesService.toSphericalLocation(this.getSphericalSamples((List<Long>)CoordinatesService.toMinecraftSamples(location), world));
    }

    public List<SphericalLocation> getSphericalLocations(List<MinecraftLocation> locations, World world) throws RestClientException {
        return CoordinatesService.toSphericalLocations(this.getSphericalSamples(CoordinatesService.toMinecraftSamples(locations), world));
    }

    public MinecraftLocation getMinecraftLocation(SphericalLocation location, World world) throws RestClientException {
        return CoordinatesService.toMinecraftLocation(this.getMinecraftSamples((List<Double>)CoordinatesService.toSphericalSamples(location), world));
    }

    public List<MinecraftLocation> getMinecraftLocations(List<SphericalLocation> locations, World world) throws RestClientException {
        return CoordinatesService.toMinecraftLocations(this.getMinecraftSamples(CoordinatesService.toSphericalSamples(locations), world));
    }

    private static List<Long> toMinecraftSamples(List<MinecraftLocation> locations) {
        ArrayList<Long> samples = new ArrayList<Long>();
        for (MinecraftLocation location : locations) {
            samples.addAll((Collection<Long>)CoordinatesService.toMinecraftSamples(location));
        }
        return samples;
    }

    private static ImmutableList<Long> toMinecraftSamples(MinecraftLocation location) {
        return ImmutableList.of((Object)location.getX(), (Object)location.getZ());
    }

    private static List<Double> toSphericalSamples(List<SphericalLocation> locations) {
        ArrayList<Double> samples = new ArrayList<Double>();
        for (SphericalLocation location : locations) {
            samples.addAll((Collection<Double>)CoordinatesService.toSphericalSamples(location));
        }
        return samples;
    }

    private static ImmutableList<Double> toSphericalSamples(SphericalLocation location) {
        return ImmutableList.of((Object)location.getLatitude(), (Object)location.getLongitude());
    }

    private static List<MinecraftLocation> toMinecraftLocations(List<Long> samples) {
        ArrayList<MinecraftLocation> locations = new ArrayList<MinecraftLocation>();
        for (List sample : Lists.partition(samples, (int)2)) {
            locations.add(CoordinatesService.toMinecraftLocation(sample));
        }
        return locations;
    }

    private static MinecraftLocation toMinecraftLocation(List<Long> samples) {
        return new MinecraftLocation(samples.get(0), samples.get(1));
    }

    private static List<SphericalLocation> toSphericalLocations(List<Double> samples) {
        ArrayList<SphericalLocation> locations = new ArrayList<SphericalLocation>();
        for (List sample : Lists.partition(samples, (int)2)) {
            locations.add(CoordinatesService.toSphericalLocation(sample));
        }
        return locations;
    }

    private static SphericalLocation toSphericalLocation(List<Double> samples) {
        return new SphericalLocation(samples.get(0), samples.get(1));
    }

    protected List<Double> getSphericalSamples(List<Long> samples, World world) throws RestClientException {
        Double[] response;
        if (CoordinatesService.validQueryParameterSize(samples)) {
            String url = "http://COORDINATES/api/v1/world/{world}?samples={samples}";
            response = (Double[])this.restTemplate.getForObject(url, Double[].class, CoordinatesService.urlVariables(samples, world));
        } else {
            String url = "http://COORDINATES/api/v1/world/" + (Object)((Object)world);
            response = (Double[])this.restTemplate.postForObject(url, samples, Double[].class, new Object[0]);
        }
        return Arrays.asList(response);
    }

    protected List<Long> getMinecraftSamples(List<Double> samples, World world) throws RestClientException {
        Long[] response;
        if (CoordinatesService.validQueryParameterSize(samples)) {
            String url = "http://COORDINATES/api/v1/{world}/world?samples={samples}";
            response = (Long[])this.restTemplate.getForObject(url, Long[].class, CoordinatesService.urlVariables(samples, world));
        } else {
            String url = "http://COORDINATES/api/v1/" + (Object)((Object)world) + "/world";
            response = (Long[])this.restTemplate.postForObject(url, samples, Long[].class, new Object[0]);
        }
        return Arrays.asList(response);
    }

    private static <T> boolean validQueryParameterSize(List<T> samples) {
        return samples.size() <= 4;
    }

    private static <T> Map<String, Object> urlVariables(List<T> samples, World world) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("world", (Object)world);
        variables.put("samples", Joiner.on((char)',').join(samples));
        return variables;
    }
}

