/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.HashMap;
import java.util.Locale;
import net.openstreetcraft.api.model.SphericalLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class LocationService {
    private static final String ENDPOINT = "http://LOCATION/api/v1";
    private final RestTemplate restTemplate;

    @Autowired
    public LocationService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public SphericalLocation getLocation(String address) throws RestClientException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("address", address);
        return (SphericalLocation)this.restTemplate.getForObject("http://LOCATION/api/v1/location?address={address}", SphericalLocation.class, variables);
    }

    public SphericalLocation getLocation(String address, SphericalLocation currentLocation) throws RestClientException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("address", address);
        variables.put("longitude", LocationService.stripDigits(currentLocation.getLongitude()));
        variables.put("latitude", LocationService.stripDigits(currentLocation.getLatitude()));
        return (SphericalLocation)this.restTemplate.getForObject("http://LOCATION/api/v1/location?address={address}&longitude={longitude}&latitude={latitude}", SphericalLocation.class, variables);
    }

    public String getAddress(SphericalLocation location) throws RestClientException {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("longitude", location.getLongitude());
        variables.put("latitude", location.getLatitude());
        return (String)this.restTemplate.getForObject("http://LOCATION/api/v1/address?longitude={longitude}&latitude={latitude}", String.class, variables);
    }

    private static String stripDigits(double value) {
        return String.format(Locale.US, "%.5f", value);
    }
}

