/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.openstreetcraft.api.geom.Raster;
import net.openstreetcraft.api.geom.RectangularBoundingBox;
import net.openstreetcraft.api.model.Layer;
import net.openstreetcraft.api.model.World;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class MapService {
    private static final String ENDPOINT = "http://MAP/api/v1";
    private final RestTemplate restTemplate;

    @Autowired
    public MapService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public ImmutableSet<World> getWorlds() throws RestClientException {
        ImmutableSet.Builder worlds = ImmutableSet.builder();
        for (Object map : (Iterable)this.restTemplate.getForObject("http://MAP/api/v1/maps", Iterable.class, new Object[0])) {
            try {
                worlds.add((Object)World.of((String)map));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return worlds.build();
    }

    public ImmutableSet<Layer> getLayers(World world) throws RestClientException {
        ImmutableSet.Builder layers = ImmutableSet.builder();
        HashMap<String, World> variables = new HashMap<String, World>();
        variables.put("map", world);
        String url = "http://MAP/api/v1/maps/{map}/layers";
        for (Object layer : (Iterable)this.restTemplate.getForObject(url, Iterable.class, variables)) {
            try {
                layers.add((Object)Layer.of((String)layer));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return layers.build();
    }

    public Raster<Byte> getByteSamples(World world, Layer layer, RectangularBoundingBox bbox, int width, int height) throws RestClientException {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("map", (Object)world);
        variables.put("layer", (Object)layer);
        variables.put("minx", bbox.getLowerLeft().getY());
        variables.put("miny", bbox.getLowerLeft().getX());
        variables.put("maxx", bbox.getUpperRight().getY());
        variables.put("maxy", bbox.getUpperRight().getX());
        variables.put("width", width);
        variables.put("height", height);
        String url = "http://MAP/api/v1/maps/{map}/layers/{layer}/bytes?minx={minx}&miny={miny}&maxx={maxx}&maxy={maxy}&width={width}&height={height}";
        byte[] samples = (byte[])this.restTemplate.getForObject(url, byte[].class, variables);
        return new Raster<Byte>(width, height, MapService.toByteArray(samples));
    }

    private static Byte[] toByteArray(byte[] array) {
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public Raster<Float> getFloatSamples(World world, Layer layer, RectangularBoundingBox bbox, int width, int height) throws RestClientException {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("map", (Object)world);
        variables.put("layer", (Object)layer);
        variables.put("minx", bbox.getLowerLeft().getY());
        variables.put("miny", bbox.getLowerLeft().getX());
        variables.put("maxx", bbox.getUpperRight().getY());
        variables.put("maxy", bbox.getUpperRight().getX());
        variables.put("width", width);
        variables.put("height", height);
        String url = "http://MAP/api/v1/maps/{map}/layers/{layer}/floats?minx={minx}&miny={miny}&maxx={maxx}&maxy={maxy}&width={width}&height={height}";
        byte[] samples = (byte[])this.restTemplate.getForObject(url, byte[].class, variables);
        return new Raster<Float>(width, height, MapService.toFloatArray(samples));
    }

    private static Float[] toFloatArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        Float[] result = new Float[bytes.length / 4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Float.valueOf(byteBuffer.getFloat(i * 4));
        }
        return result;
    }
}

