/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.List;
import java.util.Map;
import net.openstreetcraft.api.model.MinecraftLocation;
import net.openstreetcraft.api.model.SphericalLocation;
import net.openstreetcraft.api.model.World;
import net.openstreetcraft.api.service.AbstractLoader;
import net.openstreetcraft.api.service.CoordinatesService;

public class MinecraftLocationLoader
extends AbstractLoader<SphericalLocation, MinecraftLocation> {
    private final CoordinatesService service;
    private final World world;

    public MinecraftLocationLoader(CoordinatesService service, World world) {
        this.service = service;
        this.world = world;
    }

    @Override
    protected Map<SphericalLocation, MinecraftLocation> fetchAll(List<SphericalLocation> keys) {
        return MinecraftLocationLoader.combine(keys, this.service.getMinecraftLocations(keys, this.world));
    }

    @Override
    protected MinecraftLocation fetch(SphericalLocation key) {
        return this.service.getMinecraftLocation(key, this.world);
    }
}

