/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import com.esri.core.geometry.Envelope2D;
import com.google.common.annotations.VisibleForTesting;
import de.ixilon.osm.api.OverpassClient;
import de.ixilon.osm.schema.Osm;
import de.ixilon.osm.schema.OsmAdapter;
import de.ixilon.osm.schema.OsmRoot;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.openstreetcraft.api.geom.RectangularBoundingBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class OverpassService {
    private static final int DIGITS = 3;
    private static final BigDecimal FACTOR = BigDecimal.ONE.movePointLeft(3);
    private static final RetryPolicy<Object> RETRY_POLICY = ((RetryPolicy)new RetryPolicy().handle(RestClientException.class)).withBackoff(1L, 30L, ChronoUnit.SECONDS).withMaxRetries(3);
    private final OverpassClient xapiClient;
    private final OverpassClient xmlClient;

    @Autowired
    public OverpassService(RestTemplate restTemplate) {
        this.xapiClient = new OverpassClient(OverpassService.endpoint("xapi"), restTemplate);
        this.xmlClient = new OverpassClient(OverpassService.endpoint("interpreter"), restTemplate);
    }

    private static URI endpoint(String path) {
        try {
            return new URI(String.format("http://OVERPASS/api/%s", path));
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Deprecated
    public Osm getOsm(RectangularBoundingBox bbox) {
        return new OsmAdapter(this.getOsmRoot(bbox));
    }

    @Deprecated
    public Osm getOsm(Envelope2D bbox) {
        return new OsmAdapter(this.getOsmRoot(bbox));
    }

    public OsmRoot getOsmRoot(RectangularBoundingBox bbox) {
        double xmin = bbox.getLowerLeft().getX();
        double xmax = bbox.getUpperRight().getX();
        double ymin = bbox.getLowerLeft().getY();
        double ymax = bbox.getUpperRight().getY();
        return this.getOsmRoot(new Envelope2D(xmin, ymin, xmax, ymax));
    }

    public OsmRoot getOsmRoot(Envelope2D bbox) {
        return this.getOsmRoot(OverpassService.query(OverpassService.round(bbox)));
    }

    protected OsmRoot getOsmRoot(String query) {
        return (OsmRoot)Failsafe.with((Policy[])new RetryPolicy[]{RETRY_POLICY}).get(() -> this.xapiClient.get(query));
    }

    @VisibleForTesting
    static String query(Envelope2D bbox) {
        return String.format("*[bbox=%s,%s,%s,%s]", bbox.xmin, bbox.ymin, bbox.xmax, bbox.ymax);
    }

    @VisibleForTesting
    static Envelope2D round(Envelope2D bbox) {
        return new Envelope2D(OverpassService.roundDown(bbox.xmin), OverpassService.roundDown(bbox.ymin), OverpassService.roundUp(bbox.xmax), OverpassService.roundUp(bbox.ymax));
    }

    private static double roundDown(double value) {
        return BigDecimal.valueOf(value).setScale(3, RoundingMode.FLOOR).subtract(FACTOR).doubleValue();
    }

    private static double roundUp(double value) {
        return BigDecimal.valueOf(value).setScale(3, RoundingMode.CEILING).add(FACTOR).doubleValue();
    }

    @Deprecated
    public Osm getOsmByNode(long nodeId) {
        return new OsmAdapter(this.getOsmRootByNode(nodeId));
    }

    @Deprecated
    public Osm getOsmByWay(long wayId) {
        return new OsmAdapter(this.getOsmRootByWay(wayId));
    }

    public OsmRoot getOsmRootByNode(long nodeId) {
        String format = "<id-query type='node' ref='%d'/><print/>";
        return this.postOsmRoot(String.format(format, nodeId));
    }

    public OsmRoot getOsmRootByWay(long wayId) {
        String format = "<union><id-query type='way' ref='%d'/><recurse type='way-node'/></union><print/>";
        return this.postOsmRoot(String.format(format, wayId));
    }

    protected OsmRoot postOsmRoot(String query) {
        return (OsmRoot)Failsafe.with((Policy[])new RetryPolicy[]{RETRY_POLICY}).get(() -> this.xmlClient.post(query));
    }
}

