/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.List;
import java.util.Map;
import net.openstreetcraft.api.model.MinecraftLocation;
import net.openstreetcraft.api.model.SphericalLocation;
import net.openstreetcraft.api.model.World;
import net.openstreetcraft.api.service.AbstractLoader;
import net.openstreetcraft.api.service.CoordinatesService;

public class SphericalLocationLoader
extends AbstractLoader<MinecraftLocation, SphericalLocation> {
    private final CoordinatesService service;
    private final World world;

    public SphericalLocationLoader(CoordinatesService service, World world) {
        this.service = service;
        this.world = world;
    }

    @Override
    protected Map<MinecraftLocation, SphericalLocation> fetchAll(List<MinecraftLocation> keys) {
        return SphericalLocationLoader.combine(keys, this.service.getSphericalLocations(keys, this.world));
    }

    @Override
    protected SphericalLocation fetch(MinecraftLocation key) {
        return this.service.getSphericalLocation(key, this.world);
    }
}

