/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.HashMap;
import net.openstreetcraft.api.model.SphericalLocation;
import net.openstreetcraft.api.model.Timezone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class TimezoneService {
    private static final String ENDPOINT = "http://TIMEZONE/api/v1";
    private final RestTemplate restTemplate;

    @Autowired
    public TimezoneService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public Timezone getTimezone(SphericalLocation location) throws RestClientException {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("longitude", location.getLongitude());
        variables.put("latitude", location.getLatitude());
        return (Timezone)this.restTemplate.getForObject("http://TIMEZONE/api/v1/timezone?longitude={longitude}&latitude={latitude}", Timezone.class, variables);
    }
}

