/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.api.service;

import java.util.HashMap;
import net.openstreetcraft.api.model.SphericalLocation;
import net.openstreetcraft.api.model.Weather;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class WeatherService {
    private static final String ENDPOINT = "http://WEATHER/api/v1";
    private final RestTemplate restTemplate;

    @Autowired
    public WeatherService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public Weather getWeather(SphericalLocation currentLocation) throws RestClientException {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("longitude", currentLocation.getLongitude());
        variables.put("latitude", currentLocation.getLatitude());
        return (Weather)this.restTemplate.getForObject("http://WEATHER/api/v1/weather?longitude={longitude}&latitude={latitude}", Weather.class, variables);
    }
}

