/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.geom;

import net.openstreetcraft.osm.geom.Rectangle;
import net.openstreetcraft.osm.geom.Vector2D;

public class Circle2D {
    private final double xcenter;
    private final double ycenter;
    private final double radius;

    public Circle2D(Rectangle center, double radius) {
        this.xcenter = center.toRectangle2D().getCenterX();
        this.ycenter = center.toRectangle2D().getCenterY();
        this.radius = radius;
    }

    public Circle2D(double xcenter, double ycenter, double radius) {
        this.xcenter = xcenter;
        this.ycenter = ycenter;
        this.radius = radius;
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return this.intersectsLine(new Vector2D(x1, y1), new Vector2D(x2, y2));
    }

    public boolean intersectsLine(Vector2D p1, Vector2D p2) {
        double c;
        Vector2D d = p2.diff(p1);
        Vector2D f = p1.diff(new Vector2D(this.xcenter, this.ycenter));
        double a = d.dot(d);
        double b = 2.0 * f.dot(d);
        double dis = b * b - 4.0 * a * (c = f.dot(f) - this.radius * this.radius);
        if (dis < 0.0) {
            return false;
        }
        dis = Math.sqrt(dis);
        double t1 = (-b - dis) / (2.0 * a);
        double t2 = (-b + dis) / (2.0 * a);
        if (t1 >= 0.0 && t1 <= 1.0) {
            return true;
        }
        if (t2 >= 0.0 && t2 <= 1.0) {
            return true;
        }
        return t1 < 0.0 && t2 > 1.0;
    }
}

