/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.geom;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import de.ixilon.osm.schema.OsmNode;
import java.util.Arrays;
import java.util.Map;

public class OsmNodeList {
    private final Map<Long, OsmNode> nodes;

    private OsmNodeList(Map<Long, OsmNode> nodes) {
        this.nodes = nodes;
    }

    public static OsmNodeList of(OsmNode ... nodes) {
        return OsmNodeList.copyOf(Arrays.asList(nodes));
    }

    public static OsmNodeList copyOf(Iterable<OsmNode> nodes) {
        return new OsmNodeList((Map<Long, OsmNode>)Maps.uniqueIndex(nodes, OsmNode::getId));
    }

    public Optional<OsmNode> findNode(long id) {
        return Optional.fromNullable((Object)this.nodes.get(id));
    }
}

