/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.geom;

import de.ixilon.osm.schema.OsmNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.openstreetcraft.osm.geom.Rectangle;

public class OsmPoint {
    private final OsmNode node;
    private final Point2D point;

    public OsmPoint(OsmNode node) {
        this.node = node;
        this.point = new Point2D.Double(node.getLon(), node.getLat());
    }

    public boolean isInside(Rectangle bbox) {
        Rectangle2D rect = bbox.toRectangle2D();
        return this.point.getX() >= rect.getMinX() && this.point.getX() < rect.getMaxX() && this.point.getY() >= rect.getMinY() && this.point.getY() < rect.getMaxY();
    }

    public OsmNode toNode() {
        return this.node;
    }

    public Point2D toPoint2D() {
        return this.point;
    }
}

