/*
 * Decompiled with CFR 0.152.
 */
package net.openstreetcraft.osm.geom;

import de.ixilon.osm.schema.OsmNode;
import de.ixilon.osm.schema.OsmWay;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.openstreetcraft.osm.geom.Circle2D;
import net.openstreetcraft.osm.geom.OsmNodeList;
import net.openstreetcraft.osm.geom.OsmPoint;
import net.openstreetcraft.osm.geom.Rectangle;
import net.openstreetcraft.osm.util.OsmWayUtils;

public class OsmPolyline {
    private final OsmWay way;
    private final Path2D path;
    private final List<Line2D> lines;
    private Line2D line;

    public OsmPolyline(OsmWay way, OsmNodeList nodes) {
        this.way = way;
        this.path = new Path2D.Double();
        this.lines = new ArrayList<Line2D>();
        Point2D p1 = null;
        for (OsmNode node : OsmWayUtils.getNodes(way, nodes)) {
            Point2D point = new OsmPoint(node).toPoint2D();
            if (p1 == null) {
                this.path.moveTo(point.getX(), point.getY());
                p1 = point;
                continue;
            }
            this.path.lineTo(point.getX(), point.getY());
            Point2D p2 = point;
            this.lines.add(new Line2D.Double(p1, p2));
            p1 = p2;
        }
    }

    public boolean isInside(Rectangle bbox) {
        Rectangle2D rect = bbox.toRectangle2D();
        for (Line2D line : this.lines) {
            if (!rect.intersectsLine(line)) continue;
            this.line = line;
            return true;
        }
        return false;
    }

    public boolean isInside(Circle2D circle) {
        for (Line2D line : this.lines) {
            if (!circle.intersectsLine(line.getX1(), line.getY1(), line.getX2(), line.getY2())) continue;
            this.line = line;
            return true;
        }
        return false;
    }

    public final double distance(Rectangle bbox) {
        return this.distance(new Point2D.Double(bbox.toRectangle2D().getCenterX(), bbox.toRectangle2D().getCenterY()));
    }

    public final double distance(Point2D point) {
        return this.line.ptLineDist(point);
    }

    public OsmWay toWay() {
        return this.way;
    }

    public Path2D toPath2D() {
        return this.path;
    }
}

